﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

// ADCの受信情報をグラフ化に関する処理コード
// と、それを補佐する描画処理のDoubleBufferクラスを定義

namespace umehoshiEdit
{
    public partial class UmePlotForm : Form
    {
        static UmePlotForm My;
        UmehoshiEditForm umehoshiEditForm;

        private DoubleBuffer myDoubleBuffer;// ダブルバッファ
        Timer timer;//処理時間計測時に利用

        public static bool adc_start_flag = false;
        public static short[] adc_datas;// ADCの受信のサイズ受信で生成、ADC_START から ADC_END間のデータを一時的に蓄える
        public static int idx_set = 0;
        //  adc_datasは、idx_setの位置で記憶し、下記のdatasに記憶した後にnullにセット
        short[] draw_datas = null;// Plot処理は、このデータを利用

        public static int out_channel_bits = 0x03;// 3が2チャンネル利用、1がAN0のみ、2がAN1のみ 
        public static bool TextMode = false;
        static char[] tmp_char = new char[4];// ASCII時は4文字数え16ビットADCを数値に変換する時に使用
        static short[] tmp_byte = new short[2];// BINARRY用で、2byteをリトル・エンディアンとして16bitに変換
        static int tmp_cnt = 0;//（ASCII時は4、BINARRY時は2まで数える）

        public static System.IO.StreamWriter streamCSVWriter = null;
        //このオブジェクトが存在する場合、ADCの受信データをファイルに出力する時に使う
        public static int dataCount = 0;// 受信データ数カウント
        public static string writeCSVsreing = "";

        public UmePlotForm()
        {
            InitializeComponent();
        }

        public UmePlotForm(UmehoshiEditForm form)
        {
            InitializeComponent();
            this.umehoshiEditForm = form;
            My = this;
            timer = new Timer()
            {
                Interval = 20,
                Enabled = true,
            };
            timer.Tick += new EventHandler(timer_Tick);//描画を促す
        }

        // 順次得られるADCの値data をファイルに書き込む
        static void csv_file_output(short data)
        {
            if (streamCSVWriter == null) return;
            UmePlotForm.dataCount++;

            Wave.WriteData0(data, out_channel_bits == 0x03 ? 2 : 1); // ★★★　Waveファイル生成書き込み検討用
            if (out_channel_bits == 3)
            {
                int count = (UmePlotForm.dataCount - 1) / 2 + 1;
                if(UmePlotForm.dataCount % 2 == 1)
                {
                    writeCSVsreing = String.Format("{0},{1},", count, data);
                } else
                {
                    writeCSVsreing += data + "\r\n";
                    UmePlotForm.streamCSVWriter.Write(writeCSVsreing);
                }
            }else
            {
                writeCSVsreing = String.Format("{0},{1}\r\n", UmePlotForm.dataCount, data);
                UmePlotForm.streamCSVWriter.Write(writeCSVsreing);
            }
        }

        // adc_datas にASCIIコードのcodeを記憶して、一杯になった時点で描画処理をしてfalseを返す。
        public static bool setADC_data_ascii(int code)
        {
            if (adc_datas == null) return true;
            if ( code == 0x0d || code == 0x0a ) return true;
            tmp_char[tmp_cnt++] = (char)code;
            if(tmp_cnt >= 4)
            {
                tmp_cnt = 0;
                string sv = new string(tmp_char);
                adc_datas[idx_set++] = (short)Convert.ToInt32(sv, 16);
                csv_file_output((short)Convert.ToInt32(sv, 16));
                //if(idx_set % 16 == 0) Debug.Print("-----" + idx_set);

                if (idx_set >= adc_datas.Length)// バッファに溜まった。
                {
                    if (My != null)
                    {
                        My.draw_datas = adc_datas;
                        if (My.Visible)
                        {
                            My.plot();//表示中の場合だけ描画
                        }
                    }
                    UmePlotForm.adc_datas = null;
                    idx_set = 0;
                    return false;
                }
            }
            return true;
        }

        // adc_datas にバイナリのcodeを記憶して、一杯になった時点で描画処理をしてfalseを返す。
        public static bool setADC_data(int code)
        {
            if (UmePlotForm.TextMode == true) return setADC_data_ascii(code);
            if (adc_datas == null) return true;
            tmp_byte[tmp_cnt++] = (short)code;
            if (tmp_cnt >= 2)
            {
                tmp_cnt = 0;
                int val = tmp_byte[0] + (tmp_byte[1]<<8);

                adc_datas[idx_set++] = (short)val;
                csv_file_output((short)val);

                //if(idx_set % 16 == 0) Debug.Print("-----" + idx_set);
                //Debug.Print(idx_set+"");
                if (idx_set >= adc_datas.Length)// バッファに溜まった。
                {
                    if (My != null)
                    {
                        My.draw_datas = adc_datas;
                        if (My.Visible)
                        {
                            My.plot();//表示中の場合だけ描画
                        }
                    }
                    UmePlotForm.adc_datas = null;
                    idx_set = 0;

                    return false;
                }
            }
            return true;
        }

        // draw_datasの内容で描画処理
        public void plot()
        {
            // 処理時間を計測の開始
            System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
            sw.Start();
            try
            {
                Invoke((MethodInvoker)delegate
                {
                    if (out_channel_bits == 3)
                    {
                        plot2();//AN0, AN1 の両方
                    }
                    else
                    {
                        plot1(out_channel_bits == 1 ? 0 : 1);//AN0　または AN1 の一方
                    }
                });
            }
            catch (Exception )
            {
                Debug.Print("plot Error");
            }
            // 処理時間を計測　ここまで！
            sw.Stop();
            double time = sw.ElapsedTicks / (double)System.Diagnostics.Stopwatch.Frequency * 1000.0;
            //MessageBox.Show("DrawTime = " + time.ToString() + "msec");
            //Debug.Print("DrawTime = " + time.ToString() + "msec");
        }

        // AN0, AN1両方
        public void plot2()
        {
            int Width = pictureBox1.Width;
            int Height = pictureBox1.Height;

            if (myDoubleBuffer == null || draw_datas == null || draw_datas.Length < 2) return;

            // Graphicsオブジェクトの取得
            Graphics g = myDoubleBuffer.Graphics;

            Pen p = Pens.Red;
            Pen pp = Pens.Green;
            Pen pB = Pens.Blue;

            try
            {   // 背景の消去
                g.Clear(pictureBox1.BackColor);

                g.DrawLine(pB, 0, Height / 2, Width, Height / 2);

                float dx = (float)Width / draw_datas.Length;
                float dy = (float)Height / 2 / 0x0400;
                //Debug.Print("プロット間隔x:" + dx + "  y:" + dy);

                float ym = Height / 2; // y1,y2を上に配置する場合の移動量
                float x2, x1 = 0 * dx;
                float y2, y1 = Height - draw_datas[0] * dy;
                float yy2, yy1 = Height - draw_datas[1] * dy;
                //Debug.Print("先頭 x1=" + x1 + ", y1=" + dy);

                for (int i = 2; i < draw_datas.Length; i += 2)
                {
                    x2 = i * dx;
                    y2 = Height - draw_datas[i] * dy;
                    yy2 = Height - draw_datas[i + 1] * dy;

                    g.DrawLine(p, x1, y1 - ym, x2, y2 - ym);
                    g.DrawLine(pp, x1, yy1, x2, yy2);

                    x1 = x2;
                    y1 = y2;
                    yy1 = yy2;
                }
                myDoubleBuffer.Refresh();// 更新
            }
            catch (Exception e) { throw  e; }
        }

        // adcNo:0はAN0、または,adcNo:1はAN1
        public void plot1(int adcNo)
        {
            int Width = pictureBox1.Width;
            int Height = pictureBox1.Height;

            if (myDoubleBuffer == null || draw_datas == null || draw_datas.Length < 2) return;

            // Graphicsオブジェクトの取得
            Graphics g = myDoubleBuffer.Graphics;

            Pen p = adcNo == 1 ? Pens.Red : Pens.Green;
            Pen pB = Pens.Blue;

            try
            {   // 背景の消去
                g.Clear(pictureBox1.BackColor);

                g.DrawLine(pB, 0, Height / 2, Width, Height / 2);

                float dx = (float)Width / draw_datas.Length;
                float dy = (float)Height / 2 / 0x0400;
                //Debug.Print("プロット間隔x:" + dx + "  y:" + dy);

                float ym = Height / 2; // y1,y2を上に配置する場合の移動量
                float x2, x1 = 0 * dx;
                float y2, y1 = Height - draw_datas[0] * dy;
                //Debug.Print("先頭 x1=" + x1 + ", y1=" + dy);

                ym = adcNo == 0 ? ym : 0; 

                for (int i = 1; i < draw_datas.Length; i++)
                {
                    x2 = i * dx;
                    y2 = Height - draw_datas[i] * dy;

                    g.DrawLine(p, x1, y1 - ym, x2, y2 - ym);

                    x1 = x2;
                    y1 = y2;
                }
                myDoubleBuffer.Refresh();// 更新
            }
            catch (Exception e) { throw e; }
        }

        void timer_Tick(object sender, EventArgs e)
        {
            this.Invalidate();  // 再描画を促す
        }

        protected override void OnPaint(PaintEventArgs e)
        {
            plot();
        }

        private void UmePlotForm_Load(object sender, EventArgs e)
        {
            // DoubleBufferオブジェクトの作成
            myDoubleBuffer = new DoubleBuffer(pictureBox1);
        }

        private void pictureBox1_Resize(object sender, EventArgs e)
        {
            // リサイズ時は再確保
            if (myDoubleBuffer != null) myDoubleBuffer.Dispose();
            myDoubleBuffer = new DoubleBuffer(pictureBox1);
            plot();//プロット 
        }

       private void UmePlotForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            myDoubleBuffer.Dispose(); // 解放
            this.umehoshiEditForm.formUmePlot = null;
        }
    }

    // ADCの波形を描画するためのダブル バッファリング用クラス
    // コンストラクタによる生成後は、バッファ内を適宜に描画してくれる。（Refresh()で描画要求可能）
    class DoubleBuffer : IDisposable
    {
        //コンストラクタ引数を描画対象を指定する。
        BufferedGraphics myBuffer;
  
        Control _Control;// 描画対象のコントロールを記憶

        // 描画対象のコントロールを引数にする
        public DoubleBuffer(Control control)
        {
            _Control = control;

            this.Dispose();

            System.Drawing.BufferedGraphicsContext currentContext;
            currentContext = BufferedGraphicsManager.Current;

            // コントロールに関連付けられた BufferedGraphics インスタンスを取得
            myBuffer = currentContext.Allocate(control.CreateGraphics(),control.DisplayRectangle);

            // 描画が必要なタイミングで呼び出されるイベントハンドラの登録
            _Control.Paint += new System.Windows.Forms.PaintEventHandler(this.Paint);
        }

        private void Paint(object sender, PaintEventArgs e)
        {
            Refresh();
        }

        ~DoubleBuffer()
        {
            Dispose();
        }

        public void Dispose()
        {
            if (myBuffer != null)
            {
                myBuffer.Dispose();
                myBuffer = null;
            }
            _Control.Paint -= new System.Windows.Forms.PaintEventHandler(this.Paint);
        }

        public void Refresh()
        {
            if (myBuffer != null)
                myBuffer.Render();
        }

        public Graphics Graphics
        {
            get { return myBuffer.Graphics; }
        }
    }
}
