﻿using System;
using System.Collections.Generic;
using System.IO; // FileInfo用
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;//Debug利用

// TCPの送受信stream用引数でファイル操作を行うための補佐的なクラス
//  (コンストラクタ以外は、全てがstaticメソッド)
// 受信用バッファリングメソッドと、送信用staticメソッドを定義

namespace umehoshiEdit
{
    public class StreamRW
    {
        public static StreamRW requestFile = null;//セットでファイルを生成のリクエスト

        public byte[] readBuffer;// 受信で蓄えるバッファ
        private int offsetReadBuff = 0;
        private string fileName;// 現在未使用(将来の受信仕様の布石)

        static System.Text.Encoding encoding = new System.Text.UTF8Encoding(false);
        public bool actionFlag = false;// ファイル生成後の実行（実行処理はファイル拡張子で異なる）

        // コンストラクタ（受信処理で使う）
        public StreamRW(string fileName,int size)
        {
            this.fileName = fileName;
            readBuffer = new byte[size];
            this.offsetReadBuff = 0;
        }

        // TCPのstreamで、fileNameを送信する。
        public static void SendFile(Stream stream, string fileName, char cmdChar)
        {
            FileInfo fileinfo = new FileInfo(fileName);

            // 送信文字列の先頭行生成
            string firstLine = cmdChar + fileinfo.Name + ' ' + fileinfo.Length + "\r\n";

            try
            {
                byte[] buf = encoding.GetBytes(firstLine);
                stream.Write(buf, 0, buf.Length);//先頭文字列送信

                buf = new byte[fileinfo.Length];
                FileStream fs = new FileStream(fileinfo.FullName, FileMode.Open);
                int offset = 0;
                while (true)
                {
                    int count = fs.Read(buf, offset, buf.Length - offset);
                    offset += count;
                    if (offset >= buf.Length) break;
                }
                fs.Close();
                stream.Write(buf, 0, buf.Length);
                stream.Flush();
            }
            catch (Exception )
            {
                throw new Exception("TCP送信失敗！");
            }
        }

        // TCPのstreamでtext文字列メッセージ送信
        // (textに改行の文字列を含んではならなない)
        public static bool SendMessage(Stream stream, string text)
        {
            if (stream == null) return false;
            text = 'M' + text;
            byte[] buffer = encoding.GetBytes(text + "\r\n");
            stream.Write(buffer, 0, buffer.Length);
            stream.Flush();

            return true;
        }

        // 最初の1行のをstreamから読み取り、文字列を返す。
        public static string FirstReadLine(Stream stream, ref bool flag)
        {
            byte[] buffer = new byte[1000];
            int offset = 0;
            int c = 0;
            while (stream != null && flag)// 先頭行(CR LF まで)を読み取る繰り返し
            {
                c = stream.ReadByte();
                if (c == -1)
                {
                    throw new Exception("TCP receive stream closed");
                    //break;
                }
                buffer[offset++] = (byte)c;
                if (c == 10 && offset - 2 >= 0 && buffer[offset - 2] == 13) break;
            }
            string firstCmd = encoding.GetString(buffer, 0, offset);
            return firstCmd.Trim();//文字列の先頭と末尾に付いている半角、全角のスペース文字、タブ文字、改行文字などを削除
        }

        // 予めbufferとoffsetを設定しておいて、その状態で別途読み込み繰り返しで使う用途
        // 読み込みが完了すればtrueを返す。
        public bool ReadToBuffer(Stream stream)
        {
            int remainingSize = this.readBuffer.Length - this.offsetReadBuff;//残りサイズ
            if (remainingSize == 0) return true;
            int count = stream.Read(this.readBuffer, this.offsetReadBuff, remainingSize);
            this.offsetReadBuff += count;
            remainingSize = this.readBuffer.Length - this.offsetReadBuff;
            return remainingSize == 0;
        }
    }
}
