﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Text;
using System.Windows.Forms;
using System.Collections.Concurrent;//Queue
using System.Threading.Tasks;

// USB CDC「Universal Serial Bus Communications Device Class」の通信関連のstaticメソッド群を定義
// MySerialPortクラスと相互参照して利用される
// （バッファリングや「UMEHOSHI ITA」送受信文用字列操作、MySerialPort クラスの補助関数群）
//  受信したデータを直接にUmehoshiEditFormを参照してUIへ反映させる処理を含む

namespace umehoshiEdit
{
    public class HexCom
    {
        public static MySerialPort mySerialPort;// MySerialPortクラスでUSB接続時に直接設定(nullで未接続)

        public static UmehoshiEditForm mainForm;// 受信処理でアクセスする対象のMainのUmehoshiEditFormを参照
        static Task task = null;//スレッド内から上記Form内UIを直接操作するために利用

        public static StreamWriter streamWriter = null;
        //このオブジェクトが存在する場合、USBの受信データをファイルに出力する時に使う

        static int MAX_QUE = 65535; // コレクションに保持する最大個数
        static BlockingCollection<string> qeue = new BlockingCollection<string>(MAX_QUE);// キュー（先入れ先出し）を作る
        
        // quuに入っている受信データを取り出して表示
        static public void SetRecDataWithQueTaskRun()
        {
            foreach (string sv in qeue.GetConsumingEnumerable())
            {
                if (HexCom.streamWriter != null)
                {
                    HexCom.streamWriter.WriteLine(sv);//受信データファイルにも出力
                }

                // コントロールが作成されたスレッド以外のスレッドからコントロール 'textBoxCommunication' をアクセス
                mainForm.Invoke((MethodInvoker)delegate
                {
                    //System.InvalidOperationException: 回避
                    // フォームのメッセージングループに割り込んで実行させるプログラム
                    mainForm.textBoxCommunication.AppendText(sv + "\r\n");

                    // Communicationタブを前面に出す選択
                    if (mainForm.tabControl_UnderTAB.SelectedTab != mainForm.tabControl_UnderTAB.TabPages[1])
                    {
                        mainForm.tabControl_UnderTAB.SelectedTab = mainForm.tabControl_UnderTAB.TabPages[1]; //TagPageの切り替え
                        mainForm.tabControl_UnderTAB.TabPages[1].Select();
                    }
                });
            }
            task = null;
        }

        // 引数byte列を文字列へ変換
        public static string get_string(byte[] data)
        {
            string rtnval = "";
            foreach (byte c in data)
            {
                rtnval = rtnval + (char)c;
            }
            return rtnval;
        }

        // USBシリアル受信で実行するイベントハンドラの定義
        public static void dataReceived(byte[] data)
        {
            string sv = get_string(data);// 行単位受信で得た情報を文字列化
            if (sv == "ADC_START")
            {
                UmePlotForm.adc_start_flag = true;
                UmePlotForm.out_channel_bits = 3;// AN0,AN1の両チャンネル使用
            }
            else if (sv == "ADC_START0")
            {
                UmePlotForm.adc_start_flag = true;
                UmePlotForm.out_channel_bits = 1;// AN0のチャンネルだけ使用
            }
            else if (sv == "ADC_START1")
            {
                UmePlotForm.adc_start_flag = true;
                UmePlotForm.out_channel_bits = 2;// AN1の両ャンネルだけ使用
            }

            // キューに入れる。
            bool addSuccess = qeue.TryAdd(sv, System.Threading.Timeout.Infinite);
            if(! addSuccess || qeue.Count > MAX_QUE)
            {
                HexCom.mainForm.print_message("受信スレッド内　Queue記憶数：" + qeue.Count);
            }

            if (task == null)// キューの取り出し処理が終わっている？
            {
                // キューから取り出して出力
                task = Task.Run(() => {
                    SetRecDataWithQueTaskRun();//　キューの取り出し処理
                });
            }
        }

        // 文字をすべて加算して、チェックサムを求める（独自方法）
        public static String checkSum(String s)
        {
            char[] rv = { '0', '0' };

            int chk = 0;
            for (int i = 0; i < s.Length; i++)
            {
                chk += s[i];
                //Console.WriteLine("checkSum:" + chk + "," + (int)s[i]);
            }
            chk = chk & 0x0ff;
            chk = 0x100 - chk;
            int c = (chk & 0x0f0) >> 4;
            rv[0] = (char)(c < 10 ? c + '0' : c - 10 + 'A');
            c = chk & 0x0f;
            rv[1] = (char)(c < 10 ? c + '0' : c - 10 + 'A');
            return "" + rv[0] + rv[1];
        }

        // HEXフォーマット用で、先頭文字のコロンを除いた文字列で、2文字ごとにバイトに変換して加算する方式（本来のインテルHEXフォーマット）
        static String checkSum2(String s)
        {
            char[] rv = { '0', '0' };

            int chk = 0;
            for (int i = 1; i < s.Length; i++)
            {
                int d1 = s[i] < 'A' ? s[i] - '0' : s[i] - 'A' + 10;
                i++;


                int d2 = s[i] < 'A' ? s[i] - '0' : s[i] - 'A' + 10;
                int data = (d1 << 4) + d2;
                chk += data;
                //Console.WriteLine(chk + "," + data + String.Format("------------{0:D}, {1:X}", chk, data));
            }
            chk = chk & 0x0ff;
            chk = 0x100 - chk;
            int c = (chk & 0x0f0) >> 4;
            rv[0] = (char)(c < 10 ? c + '0' : c - 10 + 'A');
            c = chk & 0x0f;
            rv[1] = (char)(c < 10 ? c + '0' : c - 10 + 'A');
            return "" + rv[0] + rv[1];
        }

        // 「UMEHOSHI ITA」へUmeHexフォーマットファイルを送信して、メモリにセットさせる
        public static void send_umeHex(string hexFullPath)
        {
            // ファイル内容例「S10A0000660008000082488BF013C206128AC00000000B3」(S 10 A0000660 00 80000824 88BF013C 206128AC 00000000 B3)
            // 'S'レコード種別1byteコード, 1byteオフセット値(データ長) ,アドレス16進8byte, 2byteレコード種別, 2byteチェックサム
            StreamReader sr = new StreamReader(hexFullPath);
            while (sr.Peek() != -1)
            {
                string s = sr.ReadLine().Trim();
                //Console.WriteLine("「" + s + "」を送信します。");
                byte[] buffer = System.Text.Encoding.ASCII.GetBytes(s);// + "\x0d");
                // System.Threading.Thread.Sleep(100);
                if (HexCom.mySerialPort == null) break;
                HexCom.mySerialPort.SendDataCRLF(buffer);
                // Console.WriteLine("SEND :" + s + ":" + buffer.Length + "byteしました。");
            }
            sr.Close();
        }

        // 「UMEHOSHI ITA」へメモリ要求コマンドを送信(sizeの最大値は0で、それは256を意味する）
        public static void send_GetUmeHex(UInt32 start_addr, ushort size)
        {
            string sHex = String.Format("{0,8:X8}", start_addr);//8文字分使い、X8で8に満たない箇所を0で埋める
            sHex = "G10" + sHex + "00";
            sHex += HexCom.checkSum(sHex);
            //Console.WriteLine(sHex);
            // 送信内容例「G10000066000xx」(C 00 A0000660 00 xx)
            if (HexCom.mySerialPort != null && HexCom.mySerialPort.isOpen())
            {
                byte[] buffer = System.Text.Encoding.ASCII.GetBytes(sHex);// + "\x0d");
                HexCom.mySerialPort.SendDataCRLF(buffer);
            }
        }

        // 「UMEHOSHI ITA」へ引数のアドレスより実行するコマンドを送信
        public static void send_JUMP_commad(UInt32 start_addr)
        {
            string sHex = String.Format("{0,8:X8}", start_addr);//8文字分使い、X8で8に満たない箇所を0で埋める();
            sHex = "R00" + sHex +"00";
            sHex += HexCom.checkSum(sHex);
            Console.WriteLine(sHex);
            UmehoshiEditForm.My.textBoxMessage.Text += "Excecute Command【" + sHex + "】\r\n"; 
            // 送信内容例「R00A000066000xx」(C 00 A0000660 00 xx)
            if (HexCom.mySerialPort != null && HexCom.mySerialPort.isOpen()){
                byte[] buffer = System.Text.Encoding.ASCII.GetBytes(sHex);// + "\x0d");
                HexCom.mySerialPort.SendDataCRLF(buffer);
            }
        }

        // テスト用
        public static void test1()
        {
            string s = ":1022340000ff083488bf013c106128ac0100082469";
            string v = checkSum2(s.ToUpper());
            Console.WriteLine(v);
            return;
        }
    }
}

