﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text;

// アプリの終了時にConfKeyのキーの情報保存し、起動時に記憶した情報を復元する「Config」クラスを定義.
// また、各種設定用の補佐関数がstaticで定義（ comboBox の設定関連のstatic メソッド）を持つ.

namespace umehoshiEdit
{
    public enum ConfKey // 前回終了時の保存対象
    {
        COM_PORT_NAME,//USB CDC のポート名（例："COM3")
        IP_ADDRESS,
        PORT_NUMBER
    };

    public class Config
    {

        public static Config My = null;

        Dictionary<string, string> dic = new Dictionary<string, string>();

        // 記憶対象は直後のメンバ情報をキーにして、上記辞書に記憶する。
        public const string root_directory = "root_directory";// プロジェクトで使うルートディレクトリ（例えば、ツリーのルートとなるパス）
        public const string sdk_path = "sdk_path";// 例えば「C:\Microchip\xc32\v2.10」のようなパスを記憶
        // 上記情報が、このオブジェクトの記憶対象

        string filename = "appconf.txt";// 起動位置に作るこの名前のファイルに各種情報を記憶

        public string get(string key)
        {
            if (dic.ContainsKey(key))
            {
                return dic[key];
            }
            else
            {
                return "";
            }
        }

        public void put(string key, string val)
        {
            dic[key] = val;
        }

        // コンストラクタ（ファイルから情報を復元）
        public Config()
        {
            Config.My = this;

            string path = System.IO.Directory.GetCurrentDirectory() + "\\" + filename;
            try
            {
                using (StreamReader sr = new StreamReader(path))
                {
                    for (string s; (s = sr.ReadLine()) != null;)
                    {
                        string[] a = s.Split('=');
                        if (a.Length != 2)
                        {
                            Console.WriteLine(filename + " Format error:" + s);
                        }
                        else
                        {
                            put(a[0], a[1]);
                            Console.WriteLine(string.Format("{0}={1}",a[0], a[1]));
                        }
                    }
                }               
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
            }

            if (dic.ContainsKey(root_directory) == false)
            {
                dic[root_directory] = System.IO.Directory.GetCurrentDirectory();
            }
            else
            {
                path = dic[root_directory];
                DirectoryInfo di = new DirectoryInfo(path);
                if (di.Exists == false)
                {
                    dic[root_directory] = System.IO.Directory.GetCurrentDirectory();
                }
            }
        }

        // デストラクタ（情報をファイルに記憶する）
        ~Config()
        {
            string path = System.IO.Directory.GetCurrentDirectory() + "\\" + filename;
            using (StreamWriter sw = new StreamWriter(path))
            {
                foreach (string key in dic.Keys)
                {
                    string val = dic[key];
                    string s = string.Format("{0}={1}",key, val);
                    sw.WriteLine(s);
                }
            }
        }

        // cbox のTextがitems内に無ければitems先頭追加する。
        // 追加した結果でitems内の個数がローカル変数NNを超えた場合、items内後の要素を削除する。
        // cbox のTextがitems内にある場合、その要素をitems先頭に移動する。
        public static void setCombBox(System.Windows.Forms.ToolStripComboBox cbox)
        {
            string txt = cbox.Text;
            if (txt == "") return;
            if (cbox.Items.Count == 0)
            {
                cbox.Items.Add(txt);// 空の場合の追加
                return;
            }
            // 検索
            int i = cbox.Items.IndexOf(txt);
            if (i == 0) return;
            if(i != -1)
            {
                cbox.Items.RemoveAt(i);
            }
            cbox.Items.Insert(0, txt);//先頭に挿入
            cbox.Text = txt;
        }
    }
}
