﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Threading;
using System.Diagnostics;//Debug利用

namespace umehoshiEdit
{
    public partial class UmehoshiEditForm : Form
    {
        public static UmehoshiEditForm My;//自身を参照

        public UmeTcpClientForm formTcpClient;// TCP通信用フォーム

        public UmePlotForm formUmePlot; // ADCの受信結果表示用

        public BuildTool myBuildTool;  //コンパイラ関連クラス（以前の名前m_appMember：）

        TextBaseCtrl[] m_textBaseCtrl = new TextBaseCtrl[1];
        int m_IdxActive = 0;//上記配列のアクティブになっている要素番号

        int setTreeViewSub_count = 0;// setTreeViewSubで、Treeを登録する回数
        const int setTreeViewSub_maxCount = 4000;//上記がこの数以上の場合、 setTreeViewSubの実行を中断する。

        private ContextMenuStrip docMenu;// 右クリックメニュー用

        public UInt32 startAddressr = (UInt32)0x80004000;//メモリ内容取得の初期値地
        public ushort numberOfByte = (ushort)16;
        public UInt32 excuteAddress = (UInt32)0x80005000;//実行スタートの初期値地

        public UmehoshiEditForm()
        {
            My = this;
            new Config();//前回終了時の情報を復元

            InitializeComponent();
            setVisibleToolFprite(true, true, false, false);

            myBuildTool = new BuildTool(this.textBoxMessage);//コンパイルなどの結果表示先を引数で指定

            m_textBaseCtrl[0] = new TextBaseCtrl(richTextBox_Code);
            richTextBox_Code.TextChanged += new System.EventHandler(m_textBaseCtrl[m_IdxActive].richTextBox1_TextChanged);

            string[] argv = Environment.GetCommandLineArgs();
            if (argv.Length >= 2)
            {
                m_textBaseCtrl[0].m_CurentFilePath = argv[1];
                m_textBaseCtrl[0].LoadFile(/*this.m_Inf*/);
                this.tabPage1.Text = m_textBaseCtrl[m_IdxActive].m_CurentFilePath;
                this.toolStripStatusLabel1.Text = m_textBaseCtrl[m_IdxActive].m_CurentFilePath + "の編集中";
            }
            richTextBox_Code.SelectionFont = new System.Drawing.Font("ＭＳ ゴシック", 11.5F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(128)));
            m_textBaseCtrl[m_IdxActive].font = new System.Drawing.Font("ＭＳ ゴシック", 11.5F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(128)));
            m_textBaseCtrl[m_IdxActive].DualFont = false;//デュアルフォント
            this.textBoxMessage.Font = new System.Drawing.Font("ＭＳ ゴシック", 11.5F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(128)));
            this.textBoxCommunication.Font = new System.Drawing.Font("ＭＳ ゴシック", 11.5F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(128)));
            

            // 通信関係の初期化
            HexCom.mainForm = this;

            //以前の設定を反映
            if (Config.My.get(Config.sdk_path) != "")
            {
                this.environmentSettingToolStripMenuItem.Text = "change sdk tool path[ " +
                    Config.My.get(Config.sdk_path) + " ]";
            }

            setTreeView(this.treeView1, Config.My.get(Config.root_directory));

            folderBrowserDialog1.SelectedPath = Config.My.get(Config.root_directory);

            this.toolStripComboBoxStartAddress.Text = String.Format("0x{0,8:X8}", this.startAddressr);
            this.toolStripComboBoxNumberOfByte.Text = "" + numberOfByte;
            this.toolStripComboBoxExcuteAddress.Text = String.Format("0x{0,8:X8}", this.excuteAddress);

            this.formUmePlot = new UmePlotForm(this);

            setPrevCOMPort();// 以前のCOMポートの自動接続
        }

        // COMポートをサーチして、メニュー項目に設定
        List<string> SearchComPort()
        {
            HexCom.mySerialPort = new MySerialPort();
            List<string> list = MySerialPort.getComList();
            if (list == null) return null;

            this.listUpCOMToolStripMenuItem.DropDownItems.Clear();//メニュークリア
            this.listUpCOMToolStripMenuItem.Enabled = false;

            foreach (string s in list)// メニュー追加
            {
                ToolStripMenuItem tsMenuItem = new ToolStripMenuItem();
                tsMenuItem.Text = s;
                listUpCOMToolStripMenuItem.DropDownItems.Add(tsMenuItem);
                tsMenuItem.Click += new System.EventHandler(this.menuItemCOM_SET_Click);
            }
            if (listUpCOMToolStripMenuItem.DropDownItems.Count > 0)
            {
                this.listUpCOMToolStripMenuItem.Enabled = true;
            }

            //COM受信処理用の初期化
            HexCom.mainForm = this;
            HexCom.mySerialPort.DataReceived += HexCom.dataReceived;//受信割り込み処理の登録
            return list;
        }

        // COMポート名で、オープン処理（既にオープンしている場合は、閉じて開き直す）
        void SetComPortName(string select_portName)
        {
            if (select_portName == HexCom.mySerialPort.myPortName)
            {
                if (HexCom.mySerialPort.isOpen())
                {
                    this.print_message("既にオープンしています。");
                }
                return;// 既にオープン済み
            }
            if (HexCom.mySerialPort.isOpen())
            {
                HexCom.mySerialPort.Stop();
            }
            try
            {
                HexCom.mySerialPort.StartComPort(select_portName);// ここでCOMポートをオープンして受信スレッドをスタート

                // メニュー更新
                foreach (ToolStripMenuItem item in this.listUpCOMToolStripMenuItem.DropDownItems)
                {
                    if (item.Text == select_portName) item.Checked = true;
                    else item.Checked = false;
                }
                Config.My.put(ConfKey.COM_PORT_NAME.ToString(), select_portName);
                this.print_message(select_portName + "をオープンしました。(" + MySerialPort.com_rate + "bps)");
            }
            catch (Exception err)
            {
                this.print_message(err.Message);
                throw err;
            }
        }

        void setPrevCOMPort()// 以前のCOMポートの自動接続
        {
            if (SearchComPort() == null) return;
            string select_portName = Config.My.get(ConfKey.COM_PORT_NAME.ToString());
            if(select_portName != "")
            {
                try
                {
                    SetComPortName(select_portName);
                }
                catch(Exception e)
                {
                    Debug.Print(e.ToString());
                }
            }
        }

        // 現在のツリービューのルートフォルダ取得（受信ファイルの格納場所取得で利用）  
        public static string GetCuurentRootFolderPath
        {
            get
            {
                return Config.My.get(Config.root_directory);
            }
        }

        // Communication用メッセージ用TextBox取得
        public static TextBox GetCommunicationTextBox
        {
            get
            {
                return My.textBoxCommunication;
            }
        }

        //  TreeView内のファイル右クリック用ファイル転送処理
        public void contextMenuStrip_SubMenuClick(object sender, EventArgs e)
        {
            string path = getSelectPathBy(this.treeView1);

            if (this.formTcpClient == null) {
                this.formTcpClient = new UmeTcpClientForm(this);
            }
            if( UmeTcpClientForm.stream == null)
            { 
                try
                {
                    this.formTcpClient.ShowDialog(this);
                }
                catch (Exception)
                {
                }
            }
            if (UmeTcpClientForm.stream == null)
            {
                MessageBox.Show("送信先のサーバと接続していないので、送信できまん");
                return;
            } else
            {   // ファイル送信
                try
                {
                    StreamRW.SendFile(UmeTcpClientForm.stream, path, 'f');
                }
                catch (Exception err) {
                    MessageBox.Show(err.Message);
                    if (this.formTcpClient != null) UmeTcpClientForm.stream = null;
                    this.formTcpClient = null;
                    this.ToolStripMenuItemTcpConnecting.Visible = false;
                }
            }
        }

        TreeNode setTreeViewSub(DirectoryInfo di)
        {
            try
            {
                if (di.Name.StartsWith("$"))
                {
                    return null;
                }
                TreeNode treeNode = new TreeNode(di.Name);
                DirectoryInfo[] dirInfos = di.GetDirectories();
                foreach (DirectoryInfo sub in dirInfos)
                {
                    TreeNode subDir = setTreeViewSub(sub);
                    if (subDir == null) continue;
                    treeNode.Nodes.Add(subDir);
                    if (++setTreeViewSub_count >= setTreeViewSub_maxCount)
                    {
                        return treeNode;// 登録中断
                    }
                }
                FileInfo[] fileInfos = di.GetFiles();
                foreach (FileInfo fi in fileInfos)
                {
                    if ((fi.Attributes & FileAttributes.Hidden) == FileAttributes.Hidden)
                    {
                        continue;
                    }
                    if (fi.Extension != ".S" &&
                        fi.Extension != ".c" &&
                        fi.Extension != ".h" &&
                        fi.Extension != ".cpp" &&
                        fi.Extension != ".hex" &&
                        fi.Extension != ".umh" &&
                        fi.Extension != ".lst" &&
                        fi.Extension != ".csv" &&
                        fi.Extension != ".txt")
                    {
                        continue;
                    }

                    TreeNode tnode = new TreeNode(fi.Name);

                    if (fi.Extension == ".umh")// 右クリックポップメニュー追加
                    {
                        // ファイル送信の右クリック用　ContextMenuStripのdocMenuを用意
                        docMenu = new ContextMenuStrip();
                        ToolStripMenuItem sendLabel = new ToolStripMenuItem();
                        sendLabel.Text = "Send To Server";
                        sendLabel.Click += contextMenuStrip_SubMenuClick;
                        docMenu.Items.AddRange(new ToolStripMenuItem[] { sendLabel });
                        tnode.ContextMenuStrip = docMenu;
                    }
                    treeNode.Nodes.Add(tnode);
                    if (++setTreeViewSub_count >= setTreeViewSub_maxCount)
                    {
                        return treeNode;// 登録中断
                    }
                }
                return treeNode;
            }
            catch (Exception e)
            {
                Console.WriteLine("Error:" + e.Message);
            }
            return null;
        }

        // フォームのステータスバーへの表示
        public void print_message(string msg)
        {
            this.toolStripStatusLabel1.Text = msg;
        }

        // 開いているカレントタブが保存する必要がある場合に保存する。
        public void currentTabSave()
        {
            if (m_textBaseCtrl[m_IdxActive].m_changeFlag)
            {
                DialogResult result = MessageBox.Show("現在のファイルは変更されています。保存しますか？", "確認", MessageBoxButtons.YesNo);
                if (result == DialogResult.Yes)
                {
                    if (m_textBaseCtrl[m_IdxActive].m_CurentFilePath == "")
                    {
                        this.Do_Save_in_Dialog(m_textBaseCtrl[m_IdxActive].m_CurentFilePath);
                    }
                    else
                    {
                        m_textBaseCtrl[m_IdxActive].SaveFile(/*this.m_Inf*/);
                    }
                }
            }
        }


        public static string getSelectPathBy(TreeView treeView1)
        {
            // パスを得る
            string fullDirPath = Config.My.get(Config.root_directory);
            DirectoryInfo sub_root = new DirectoryInfo(fullDirPath);
            DirectoryInfo di = sub_root.Parent;
            string fullPath = "";
            if (di == null)// カレントディレクトリがルートの時
            {
                fullPath = treeView1.SelectedNode.FullPath;
            }
            else
            {
                fullPath = di.FullName + "\\" + treeView1.SelectedNode.FullPath;
            }
            return fullPath;
        }

        // treeViewにpathとその中のディレクトリ・ファイルの構造を反映させる。
        void setTreeView(TreeView treeView, string path)
        {
            treeView1.BeginUpdate();
            treeView1.Nodes.Clear();//全て削除
            setTreeViewSub_count = 0;//登録数のカウント

            DirectoryInfo di = new DirectoryInfo(path);

            TreeNode treeNode = setTreeViewSub(di);

            treeView1.Nodes.Add(treeNode);
            treeView1.TopNode = treeNode;

            treeView1.TopNode.Expand();
            treeView1.EndUpdate();
            this.toolStripStatusLabel1.Text = setTreeViewSub_count + "個のTreeNodeが登録されました。";
            if (setTreeViewSub_count >= setTreeViewSub_maxCount)
            {
                MessageBox.Show("TreeViewへの登録を中断しました。");
            }
        }

        // treeView1内のダブルクリックでソースを開く
        private void treeView1_NodeMouseDoubleClick(object sender, TreeNodeMouseClickEventArgs e)
        {
            if (treeView1.SelectedNode == null) return;
            try
            {
                // パスを得る
                string fullDirPath = Config.My.get(Config.root_directory);
                DirectoryInfo sub_root = new DirectoryInfo(fullDirPath);
                DirectoryInfo di = sub_root.Parent;
                string fullPath = "";
                if (di == null)// カレントディレクトリがルートの時
                {
                    fullPath = treeView1.SelectedNode.FullPath;
                }
                else
                {
                    fullPath = di.FullName + "\\" + treeView1.SelectedNode.FullPath;
                }
                FileInfo fi = new FileInfo(fullPath);
                if (fi.Exists == false ||
                    (fi.Attributes & FileAttributes.Directory) == FileAttributes.Directory)
                {
                    if (e.Node == treeView1.TopNode)
                    {
                        this.setTreeView(this.treeView1, Config.My.get(Config.root_directory));
                        return;
                    }
                    this.toolStrip1.Text = fullPath + "は、フォルダで開けません";
                    return;
                }

                currentTabSave();// 開いているカレントタブが保存する必要がある場合に保存する。
                setCuurentTabByTextFile(fullPath);// カレントタブにファイルをロードする。
                if (usbToFileToolStripMenuItem.Checked)
                {
                    var result = MessageBox.Show("受信ファイル生成を終了しますか？", "問い合わせ",
                                 MessageBoxButtons.YesNo,
                                 MessageBoxIcon.Question);
                    if (result == DialogResult.Yes)
                    {
                        usbToFileToolStripMenuItem.Checked = false;
                    }
                }
            }
            catch (System.ComponentModel.Win32Exception)
            {
                MessageBox.Show("開くことができません。");
                if (e.Node.Text.Contains("."))
                    System.Diagnostics.Process.Start(@"c:\" + e.Node.Text);
            }
        }

        // do_ダイアログで保存
        public void Do_Save_in_Dialog(string absPtah)
        {
            if (absPtah == "")
            {
                saveFileDialog1.InitialDirectory = Application.ExecutablePath;
                saveFileDialog1.FileName = "";
            }
            else
            {
                saveFileDialog1.InitialDirectory = Path.GetDirectoryName(absPtah);
                saveFileDialog1.FileName = Path.GetFileName(absPtah);
            }
            saveFileDialog1.ShowDialog();
        }

        //do_ダイアログで開く
        public void Do_Load_in_Dialog(string absPtah)
        {
            if (absPtah == "")
            {
                openFileDialog1.InitialDirectory = Application.ExecutablePath;
                openFileDialog1.FileName = "";
            }
            else
            {
                openFileDialog1.InitialDirectory = Path.GetDirectoryName(absPtah);
                openFileDialog1.FileName = Path.GetFileName(absPtah);
            }
            openFileDialog1.ShowDialog();
        }

        // 開くダイアログイベント
        private void openFileDialog1_FileOk(object sender, System.ComponentModel.CancelEventArgs e)
        {
            setCuurentTabByTextFile(openFileDialog1.FileName);
        }

        // CommunicationタブのTextBoxでEnterした時の文字列のUSB送信用イベント処理
        private void textBoxCommunication_KeyUp(object sender, KeyEventArgs e)
        {
            if (HexCom.mySerialPort == null || HexCom.mySerialPort.isOpen() == false) return;
            if (e.KeyCode != Keys.Return) return;
            TextBox textbox = (TextBox)sender;
            string s = textbox.Text;
            s = s.Substring(0, textbox.SelectionStart - 2);
            int idx = textbox.SelectionStart - 2;

            while (idx >= 1 && s[idx - 1] != '\x0a')
            {
                idx--;
            }
            s = s.Substring(idx);
            Console.WriteLine("textBoxCommunication_KeyUp:" + s);
            //byte[] ba = System.Text.Encoding.Unicode.GetBytes(s);
            byte[] ba = System.Text.Encoding.ASCII.GetBytes(s);
            HexCom.mySerialPort.SendDataCRLF2(ba);// "\r\n"が追加される。
        }

        // ツールバーの各種部品の可視設定指定メソッド(メニュ操作補助関数)
        private void setVisibleToolFprite(bool f, bool r, bool g, bool e)
        {
            this.toolStripLabelFind.Visible = f;
            this.toolStripComboBoxFind.Visible = f;
            this.toolStripButtonFindPrevious.Visible = f;
            this.toolStripButtonFindNext.Visible = f;

            this.toolStripLabelReplace.Visible = r;
            this.toolStripComboBoxReplace.Visible = r;
            this.toolStripButtonReplacePrevious.Visible = r;
            this.toolStripButtonReplaceNext.Visible = r;

            this.toolStripLabelAddressToGet.Visible = g;
            this.toolStripComboBoxStartAddress.Visible = g;
            this.toolStripLabelNumberOfByte.Visible = g;
            this.toolStripComboBoxNumberOfByte.Visible = g;
            this.toolStripButtonGetMemory.Visible = g;

            this.toolStripLabelStartAddress.Visible = e;
            this.toolStripComboBoxExcuteAddress.Visible = e;
            this.toolStripButtonExecute.Visible = e;
        }

        // 終了処理
        void DoQuit()
        {
            HexCom.mainForm.clearListUpCOM();
            if (this.formTcpClient != null)
            {
                this.formTcpClient.TcpClose();
            }
            if (this.formUmePlot != null)
            {
                this.formUmePlot.Close();
            }
            this.Dispose();
        }

        // アプリフォーム閉じるボタンイベント
        private void UmehoshiEditForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            DoQuit();// 終了処理
        }


        //---------------------------------------------------------------
        //  以下にメニュー関連の操作
        //---------------------------------------------------------------

        // 新規作成
        private void newFileToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (m_textBaseCtrl[m_IdxActive].m_changeFlag)
            {
                DialogResult result = MessageBox.Show("現在のファイルは変更されています。保存しますか？", "確認", MessageBoxButtons.YesNo);
                if (result == DialogResult.Yes)
                {
                    if (m_textBaseCtrl[m_IdxActive].m_CurentFilePath != "")
                    {
                        m_textBaseCtrl[m_IdxActive].SaveFile(/*this.m_Inf*/);
                    }
                    else
                    {
                        this.Do_Save_in_Dialog(m_textBaseCtrl[m_IdxActive].m_CurentFilePath);
                    }
                }
            }
            this.richTextBox_Code.Text = "";
            m_textBaseCtrl[m_IdxActive] = new TextBaseCtrl(richTextBox_Code);
            this.tabPage1.Text = "ソースファイル";
            this.toolStripStatusLabel1.Text = "新規ファイルの編集中";
        }

        // Open メニュー処理
        private void openFileToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (m_textBaseCtrl[m_IdxActive].m_changeFlag)
            {
                DialogResult result = MessageBox.Show("現在のファイルは変更されています。保存しますか？", "確認", MessageBoxButtons.YesNo);
                if (result == DialogResult.Yes)
                {
                    if (m_textBaseCtrl[m_IdxActive].m_CurentFilePath == "")
                    {
                        this.Do_Save_in_Dialog(m_textBaseCtrl[m_IdxActive].m_CurentFilePath);
                    }
                    else
                    {
                        m_textBaseCtrl[m_IdxActive].SaveFile(/*this.m_Inf*/);
                    }
                }
            }
            this.Do_Load_in_Dialog(m_textBaseCtrl[m_IdxActive].m_CurentFilePath);

        }

        private void saveFileDialog1_FileOk(object sender, System.ComponentModel.CancelEventArgs e)
        {
            m_textBaseCtrl[m_IdxActive].m_CurentFilePath = saveFileDialog1.FileName;
            if (m_textBaseCtrl[m_IdxActive].m_CurentFilePath == "")
            {
                return;
            }
            m_textBaseCtrl[m_IdxActive].SaveFile(/*this.m_Inf*/);
            this.tabPage1.Text = m_textBaseCtrl[m_IdxActive].m_CurentFilePath;
            this.toolStrip1.Text = m_textBaseCtrl[m_IdxActive].m_CurentFilePath + "の編集中";
        }

        // 引数のpathを、読み取って、アクティブなタブ内に表示させる。
        public void setCuurentTabByTextFile(string fullPath)
        {
            m_textBaseCtrl[m_IdxActive].m_CurentFilePath = fullPath;
            if (m_textBaseCtrl[m_IdxActive].m_CurentFilePath == "")
            {
                return;
            }
            m_textBaseCtrl[m_IdxActive].LoadFile(/*this.m_Inf*/);
            this.tabPage1.Text = m_textBaseCtrl[m_IdxActive].m_CurentFilePath;
            this.toolStrip1.Text = m_textBaseCtrl[m_IdxActive].m_CurentFilePath + "の編集中";

        }

        // Save
        private void saveToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (m_textBaseCtrl[m_IdxActive].m_CurentFilePath == "")
            {
                this.Do_Save_in_Dialog(m_textBaseCtrl[m_IdxActive].m_CurentFilePath);
            }
            else
            {
                m_textBaseCtrl[m_IdxActive].SaveFile(/*this.m_Inf*/);
            }
        }

        // Save As
        private void saveAsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Do_Save_in_Dialog(m_textBaseCtrl[m_IdxActive].m_CurentFilePath);
        }

        // プロジェクトのフォルダ選択
        private void selectFolderToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string folderName = Config.My.get(Config.root_directory);

            this.folderBrowserDialog1.SelectedPath = folderName;

            DialogResult result = this.folderBrowserDialog1.ShowDialog();

            if (result == DialogResult.OK)
            {
                folderName = folderBrowserDialog1.SelectedPath;
                Config.My.put(Config.root_directory, folderName);
                this.setTreeView(this.treeView1, folderName);
            }
        }

        // Exit
        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            DoQuit();// 終了処理
        }


        // Cut
        private void cutToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (richTextBox_Code.Focused && richTextBox_Code.SelectedText != "")
            {
                Clipboard.SetDataObject(richTextBox_Code.SelectedText);
                richTextBox_Code.SelectedText = "";
            }
        }

        // Copy
        private void copyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            // 選択したテキストをテキストボックスから取り出してクリップボードへ
            if (richTextBox_Code.Focused && richTextBox_Code.SelectedText != "")
                Clipboard.SetDataObject(richTextBox_Code.SelectedText);
        }

        // Past
        private void pasteToolStripMenuItem_Click(object sender, EventArgs e)
        {
            // 選択したテキストをテキストボックスから取り出してクリップボードへ
            IDataObject iData = Clipboard.GetDataObject();

            // データが使用可能な形式であるかどうかを判別
            if (richTextBox_Code.Focused && iData.GetDataPresent(DataFormats.Text))
            {
                richTextBox_Code.SelectedText = (String)iData.GetData(DataFormats.Text);
            }
        }

        // Find （検索の準備処理　検索処理はtoolStripButtonFindNextなどのボタンで行う）
        private void findToolStripMenuItem_Click(object sender, EventArgs e)
        {
            setVisibleToolFprite(true, false, false, false);
            TextBoxBase text = m_textBaseCtrl[m_IdxActive].text;
            if (text.SelectionLength > 0)
            {
                toolStripComboBoxFind.Text = text.SelectedText.Trim();
            }
        }

        // Replace （置換の準備処理　置換処理はボタンで行う）
        private void replaceToolStripMenuItem_Click(object sender, EventArgs e)
        {
            setVisibleToolFprite(true, true, false, false);
        }

        // ビルドメニュー処理
        private void BuildToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            string sdk_folder = Config.My.get(Config.sdk_path);
            FileInfo fileInfo_xc32gcc = new FileInfo(sdk_folder + @"\bin\xc32-gcc.exe");
            if (fileInfo_xc32gcc.Exists == false)
            {
                MessageBox.Show("xc32-gcc のコンパイラが見つかりません。");
                return;
            }

            if (m_textBaseCtrl[m_IdxActive].m_changeFlag)
            {
                if (m_textBaseCtrl[m_IdxActive].m_CurentFilePath == "")
                {
                    this.Do_Save_in_Dialog(m_textBaseCtrl[m_IdxActive].m_CurentFilePath);
                }
                else
                {
                    MessageBox.Show("保存してビルドします。");
                    m_textBaseCtrl[m_IdxActive].SaveFile(/*this.m_Inf*/);
                }
            }

            this.tabControl_UnderTAB.SelectedTab = this.tabControl_UnderTAB.TabPages[0]; //TagPageの切り替え
            this.tabControl_UnderTAB.TabPages[0].Select();

            // ビルドする
            this.myBuildTool.Do_build( m_textBaseCtrl[m_IdxActive].m_CurentFilePath,
                sdk_folder);
            int errLine = this.myBuildTool.checkBuildError();
            if(errLine > 0)
            {
                this.print_message("Error found in line " + errLine);
                int i1 = 0, i2 = 0;
                for (int i=0; i < errLine; i++)
                {
                    i1 = i2;
                    i2 = this.richTextBox_Code.Text.IndexOf("\n", i1+1);
                    if (i2 == -1) break;
                }
                this.richTextBox_Code.Select(i1+1, i2-(i1+1));
                this.richTextBox_Code.Focus();
            }
        }

        // xc32のコンパイラ環境などの環境位置設定操作
        private void environmentSettingToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string folderName = Config.My.get(Config.sdk_path);

            this.folderBrowserDialog1.SelectedPath = folderName;

            DialogResult result = this.folderBrowserDialog1.ShowDialog();

            if (result == DialogResult.OK)
            {
                folderName = folderBrowserDialog1.SelectedPath;
                Config.My.put(Config.sdk_path, folderName);
                this.environmentSettingToolStripMenuItem.Text = "change sdk tool path[ " +
                        Config.My.get(Config.sdk_path) + " ]";
                this.toolStrip1.Text = "ビルド環境ディレクトリ:" + folderName;

            }
        }

        // HexファイルのデータをCOMポートへ送信するメニュー処理
        private void hexSendToolStripMenuItem_Click(object sender, EventArgs e)
        {

            //HexCom.test1();// 送信実験
            string hexPath = m_textBaseCtrl[m_IdxActive].m_CurentFilePath;
            if (hexPath == null || hexPath == "")
            {
                MessageBox.Show("対象のファイルを開いてください。", "エラー", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }
            FileInfo srcFfileInfo = new FileInfo(hexPath);
            hexPath = srcFfileInfo.FullName;
            DirectoryInfo di = srcFfileInfo.Directory;  // srcPathのパスのディレクトリを取得
            string ext = Path.GetExtension(srcFfileInfo.Name);
            if (ext != ".hex")
            {
                if (ext == ".c" || ext == ".S")
                {
                    hexPath += ".hex";
                }
            }
            FileInfo hexFfileInfo = new FileInfo(hexPath);
            if (hexFfileInfo.Exists == false)
            {
                MessageBox.Show("送信ファイルの" + hexPath + "が存在しません。", "エラー", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }
            this.textBoxMessage.Text = "send file:" + hexPath + "\r\n";
            if (HexCom.mySerialPort != null && HexCom.mySerialPort.isOpen())
            {
                HexCom.send_umeHex(hexPath);//umeHexファイルの送信
                setVisibleToolFprite(false, false, true, true);

            }
            else
            {
                MessageBox.Show("COMチェックして、COMポートを選択してください。",
                    "送信COM ポートが選択されていません。（準備ができていません。）", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        // UMEHOSHI ITAよりUSBを介してメモリ内容をHex情報を受信する操作の表示
        private void hexReciveToolStripMenuItem_Click(object sender, EventArgs e)
        {
            setVisibleToolFprite(false, false, true, true);
        }

        // UMEHOSHI ITAよりUSBを介して実行操作の機能を表示
        private void commandExecToolStripMenuItem_Click(object sender, EventArgs e)
        {
            setVisibleToolFprite(false, false, true, true);
            // これで出現する[toolStripButtonExecute]ボタン操作で送信する。
        }

        // COMの初期化（COMリストも初期して、選択前に戻す）
        public void clearListUpCOM()
        {
            if (HexCom.mySerialPort != null) {
                HexCom.mySerialPort.Stop();
                HexCom.mySerialPort = null;
            }
            for (int i = listUpCOMToolStripMenuItem.DropDownItems.Count; i > 0; i--)
            {
                listUpCOMToolStripMenuItem.DropDownItems.RemoveAt(i - 1);
            }
            this.listUpCOMToolStripMenuItem.DropDownItems.Clear();

            this.listUpCOMToolStripMenuItem.Enabled = false;
        }

        // 「Check COM」のメニュー操作処理
        private void checkCOMToolStripMenuItem_Click(object sender, EventArgs e)
        {
            clearListUpCOM();//COMの初期化（COMリストも初期して、選択前に戻す）

            List<string> list = SearchComPort();
            if (list == null || list.Count == 0)
            {
                MessageBox.Show("USBの接続して、\nアプリケーションを再起動してください。", "COMポートサーチ失敗",
                            MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        // メニューで、COMの選択を行うイベント　そのCOMをオープンする。
        private void menuItemCOM_SET_Click(object sender, EventArgs e)
        {
            ToolStripMenuItem menuItem = (ToolStripMenuItem)sender;
            string select_portName = menuItem.Text;
            try
            {
                SetComPortName(select_portName);//COMポート名でオープン
                //menuItem.Checked = true;
            }
            catch (Exception err)
            {
                MessageBox.Show("USBの接続して、\nアプリケーションを再起動してください。", "COMポート選択失敗",
                            MessageBoxButtons.OK, MessageBoxIcon.Error);
                this.listUpCOMToolStripMenuItem.DropDownItems.Clear();
                this.listUpCOMToolStripMenuItem.Enabled = false;
                Debug.Print(err.ToString());
            }
        }

        // フォント変更メニュー
        private void selectFontToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string objName = this.ActiveControl.Name;

            if (objName == "richTextBox_Code")
            {
                fontDialog1.ShowColor = true;
                fontDialog1.Font = m_textBaseCtrl[m_IdxActive].text.Font;
                fontDialog1.Color = m_textBaseCtrl[m_IdxActive].text.ForeColor;
                if (fontDialog1.ShowDialog() != DialogResult.Cancel)
                {
                    m_textBaseCtrl[m_IdxActive].font = fontDialog1.Font;
                    m_textBaseCtrl[m_IdxActive].text.Font = fontDialog1.Font;
                    m_textBaseCtrl[m_IdxActive].text.ForeColor = fontDialog1.Color;
                }
            }
            else if (objName == "textBoxMessage")
            {
                fontDialog1.ShowColor = true;
                fontDialog1.Font = textBoxMessage.Font;
                fontDialog1.Color = textBoxMessage.ForeColor;
                if (fontDialog1.ShowDialog() != DialogResult.Cancel)
                {
                    textBoxMessage.Font = fontDialog1.Font;
                    textBoxMessage.ForeColor = fontDialog1.Color;
                }
            }
            else if (objName == "textBoxCommunication")
            {
                fontDialog1.ShowColor = true;
                fontDialog1.Font = textBoxCommunication.Font;
                fontDialog1.Color = textBoxCommunication.ForeColor;
                if (fontDialog1.ShowDialog() != DialogResult.Cancel)
                {
                    textBoxCommunication.Font = fontDialog1.Font;
                    textBoxCommunication.ForeColor = fontDialog1.Color;
                }
            }
            else if (objName == "treeView1")
            {
                //MessageBox.Show("");
                fontDialog1.ShowColor = true;
                fontDialog1.Font = treeView1.Font;
                fontDialog1.Color = treeView1.ForeColor;
                if (fontDialog1.ShowDialog() != DialogResult.Cancel)
                {
                    treeView1.Font = fontDialog1.Font;
                    treeView1.ForeColor = fontDialog1.Color;
                }
            }
        }

        // TCP Connect
        private void connectToolStripMenuItem_Click(object sender, EventArgs e)
        {
            // 既にTCP接続中であれば、閉じて接続Formを表示
            if (this.formTcpClient != null)
            {
                this.formTcpClient.TcpClose();
                this.formTcpClient = null;
            }
            this.formTcpClient = new UmeTcpClientForm(this);
            this.formTcpClient.Show(this);
        }

        // TCP Close
        private void tcpCloseToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (this.formTcpClient != null) this.formTcpClient.TcpClose();
            this.formTcpClient = null;
        }

        // ボーレート選択
        private void toolStripMenuItem1_Click(object sender, EventArgs e)
        {
            // なにもしない　（toolStripComboBox_USB_Rate_TextChangedで行う）
        }

        // USB bps 変更
        private void toolStripComboBox_USB_Rate_TextChanged(object sender, EventArgs e)
        {
            MessageBox.Show("COMポートを選択し直してしてください。");
        }

        // USBからの受信をファイル化する
        private void usbToFileToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //なにもしない（usbToFileToolStripMenuItem_CheckedChangedで行う）
        }
        private void usbToFileToolStripMenuItem_CheckedChanged(object sender, EventArgs e)
        {
            if (usbToFileToolStripMenuItem.Checked)
            {
                if (HexCom.streamWriter == null)
                {
                    string path = m_textBaseCtrl[m_IdxActive].m_CurentFilePath;
                    if (path == null || path == "")
                    {
                        MessageBox.Show("対象を開いてください。", "エラー", MessageBoxButtons.OK, MessageBoxIcon.Error);
                        usbToFileToolStripMenuItem.Checked = false;
                        return;
                    }
                    FileInfo srcFfileInfo = new FileInfo(path);
                    path = srcFfileInfo.FullName;
                    DirectoryInfo di = srcFfileInfo.Directory;  // srcPathのパスのディレクトリを取得
                    MessageBox.Show(path + ".txt" + "を生成し、\rUSB受信情報を記録します");
                    HexCom.streamWriter = new StreamWriter(path + ".txt");
                }
            }
            else
            {
                if (HexCom.streamWriter != null)
                {
                    HexCom.streamWriter.Close();
                    HexCom.streamWriter = null;
                }
            }
        }

        // ADCの受信をファイル（.csv）化する
        private void aDCToCSVToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //なにもしない（aDCToCSVToolStripMenuItem_CheckedChangedで行う）
            Wave.Close0();//umehoshiEdit.wavの書き込み中であれば閉じる（★★★検討用）
        }

        private void aDCToCSVToolStripMenuItem_CheckedChanged(object sender, EventArgs e)
        {
            if (aDCToCSVToolStripMenuItem.Checked)
            {
                if (UmePlotForm.streamCSVWriter == null)
                {
                    string path = m_textBaseCtrl[m_IdxActive].m_CurentFilePath;
                    if (path == null || path == "")
                    {
                        MessageBox.Show("対象を開いてください。", "エラー", MessageBoxButtons.OK, MessageBoxIcon.Error);
                        aDCToCSVToolStripMenuItem.Checked = false;
                        return;
                    }
                    FileInfo srcFfileInfo = new FileInfo(path);
                    path = srcFfileInfo.FullName;
                    DirectoryInfo di = srcFfileInfo.Directory;  // srcPathのパスのディレクトリを取得
                    MessageBox.Show(path + ".csv" + "を生成し、\rADC受信情報を記録します");
                    UmePlotForm.streamCSVWriter = new StreamWriter(path + ".csv");
                    UmePlotForm.dataCount = 0;
                }
            }
            else
            {
                if (UmePlotForm.streamCSVWriter != null)
                {
                    UmePlotForm.streamCSVWriter.Close();
                    UmePlotForm.streamCSVWriter = null;
                }
            }

        }


        // ADCのグラフ表示用のパネルを表示
        private void graphToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (this.formUmePlot == null) this.formUmePlot = new UmePlotForm(this);
            this.formUmePlot.Show();
            this.formUmePlot.Location = this.Location;
            this.formUmePlot.Left += 100;
            this.formUmePlot.Top += 100;
        }

        // web ページ表示
        private void webPageToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                string url = @"http://manabu.quu.cc/up/ume/";
                System.Diagnostics.Process process = new System.Diagnostics.Process();
                process.StartInfo.FileName = "iexplore.exe";
                process.StartInfo.Arguments = url;
                process.Start();
            }
            catch (Exception) { }
        }

        /**********************************************************************
         *　以降は、toolStrip関連動作のコード(ツールボタン）
         * ****************************************************************** */

        // メモリ取得
        private void toolStripButtonGetMemory_Click(object sender, EventArgs e)
        {
            try
            {
                string s = this.toolStripComboBoxStartAddress.Text.Trim();
                if (s.StartsWith("0x"))
                {
                    s = s.Substring(2);
                    this.startAddressr = Convert.ToUInt32(s, 16);
                    Config.setCombBox(this.toolStripComboBoxStartAddress);
                }
                else
                {
                    this.startAddressr = Convert.ToUInt32(s, 10);
                    Config.setCombBox(this.toolStripComboBoxStartAddress);
                }

                s = this.toolStripComboBoxNumberOfByte.Text;
                if (s.StartsWith("0x"))
                {
                    s = s.Substring(2);
                    this.numberOfByte = (ushort)Convert.ToUInt32(s, 16);
                    Config.setCombBox(this.toolStripComboBoxNumberOfByte);
                }
                else
                {
                    this.numberOfByte = (ushort)Convert.ToUInt32(s, 10);
                    Config.setCombBox(this.toolStripComboBoxNumberOfByte);
                }
            }
            catch (Exception ) {
                this.toolStripStatusLabel1.Text = "メモリ内容取得設定値が、正しい入力と判断されていません";
                return;
            }
            HexCom.send_GetUmeHex(this.startAddressr, this.numberOfByte);//メモリ取得コマンド送信
        }

        // UMEHOSI ITA に実行コマンドを送信する。
        private void ToolStripButtonExecute_Click(object sender, EventArgs e)
        {
            try
            {
                string s = this.toolStripComboBoxExcuteAddress.Text.Trim();
                if (s.StartsWith("0x"))
                {
                    s = s.Substring(2);
                    this.excuteAddress = Convert.ToUInt32(s, 16);
                    Config.setCombBox(this.toolStripComboBoxExcuteAddress);//登録
                }
                else
                {
                    this.excuteAddress = Convert.ToUInt32(s, 10);
                    Config.setCombBox(this.toolStripComboBoxExcuteAddress);//登録
                }
            }
            catch (Exception )
            {
                this.toolStripStatusLabel1.Text = "実行開始設定値が、正しい入力と判断されていません";
                return;
            }
            HexCom.send_JUMP_commad(this.excuteAddress);
        }


        // 文字列を前方向検索
        private void toolStripButtonFindPrevious_Click(object sender, EventArgs e)
        {
            this.richTextBox_Code.Focus();
            string str_search = toolStripComboBoxFind.Text;// 探す文字列

            Config.setCombBox(toolStripComboBoxFind);//登録

            int iStart = this.richTextBox_Code.SelectionStart;// 現在の選択位置
            if(iStart >= 1) iStart -= 1;// この位置から探す。
            int i_found = this.richTextBox_Code.Text.LastIndexOf(str_search, iStart);
            if( i_found == -1)
            {
                MessageBox.Show("『"+ str_search + "』の文字列は見つかりませんでした。");
                return;
            }
            this.richTextBox_Code.SelectionStart = i_found;
            this.richTextBox_Code.SelectionLength = str_search.Length;
        }
        
        // 文字列を後ろ方向検索
        private void toolStripButtonFindNext_Click(object sender, EventArgs e)
        {
            this.richTextBox_Code.Focus();
            string str_search = toolStripComboBoxFind.Text;// 探す文字列

            Config.setCombBox(toolStripComboBoxFind);//登録

            int iStart = this.richTextBox_Code.SelectionStart;// 現在の選択位置
            if (iStart + 1 <= this.richTextBox_Code.Text.Length) iStart += 1;// この位置から探す。
            int i_found = this.richTextBox_Code.Text.IndexOf(str_search, iStart);
            if (i_found == -1)
            {
                MessageBox.Show("『" + str_search + "』の文字列は見つかりませんでした。");
                return;
            }
            this.richTextBox_Code.SelectionStart = i_found;
            this.richTextBox_Code.SelectionLength = str_search.Length;
        }

        // 文字列を前方向置換
        private void toolStripButtonReplacePrevious_Click(object sender, EventArgs e)
        {
            this.richTextBox_Code.Focus();
            string str_search = toolStripComboBoxFind.Text;// 探す文字列

            Config.setCombBox(toolStripComboBoxFind);//登録
            Config.setCombBox(this.toolStripComboBoxReplace);//登録

            int iStart = this.richTextBox_Code.SelectionStart;// 現在の選択位置
            if (str_search != this.richTextBox_Code.SelectedText)
            {
                toolStripButtonFindPrevious_Click(sender, e);
                return;
            }
            string str_replace = this.toolStripComboBoxReplace.Text; //置き換え後文字列
            this.richTextBox_Code.SelectedText = str_replace;
            this.richTextBox_Code.SelectionStart = iStart;
            this.richTextBox_Code.SelectionLength = str_replace.Length;
        }

        // 文字列を後ろ方向検索
        private void toolStripButtonReplaceNext_Click(object sender, EventArgs e)
        {
            this.richTextBox_Code.Focus();
            string str_search = toolStripComboBoxFind.Text;// 探す文字列

            Config.setCombBox(toolStripComboBoxFind);//登録
            Config.setCombBox(this.toolStripComboBoxReplace);//登録

            int iStart = this.richTextBox_Code.SelectionStart;// 現在の選択位置
            if (str_search != this.richTextBox_Code.SelectedText) {
                toolStripButtonFindNext_Click( sender,  e);
                return;
            }
            string str_replace = this.toolStripComboBoxReplace.Text; //置き換え後文字列
            this.richTextBox_Code.SelectedText = str_replace;
            this.richTextBox_Code.SelectionStart = iStart;
            this.richTextBox_Code.SelectionLength = str_replace.Length;
        }
    }
}
