﻿using System;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using System.Net.Sockets;
using System.IO;
using System.Diagnostics;//Debug利用

// TCPのサーバへの接続操作Form
// 接続後に見えなくするが、受信スレッドを起動して、closeするまでオブジェクトとして存在する。

namespace umehoshiEdit
{
    public partial class UmeTcpClientForm : Form
    {
        UmehoshiEditForm formUmehoshiEdit;

        Thread mythread;//　クライアントの接続待ち用スレッド

        public static Stream stream;// バイト列の送受信用

        Thread myRecthread;////受信処理スレッド
        bool _isRecRunning = false;

        TcpClient tcpClient; //クライアント情報

        Encoding encoding = new UTF8Encoding(false);

        public UmeTcpClientForm(UmehoshiEditForm editForm)
        {
            InitializeComponent();
            this.formUmehoshiEdit = editForm;
        }

        private void UmeTcpClientForm_Load(object sender, EventArgs e)
        {
            string s = Config.My.get(ConfKey.IP_ADDRESS.ToString());
            this.textBoxIP.Text = s != "" ? s : "192.168.0.254";

            s = Config.My.get(ConfKey.PORT_NUMBER.ToString());
            this.textBoxPort.Text = s != "" ? s : "59154";

            this.lblMessage.Text = "";
        }

        private void btnConnect_Click(object sender, EventArgs e)
        {
            Config.My.put(ConfKey.IP_ADDRESS.ToString(), this.textBoxIP.Text);
            Config.My.put(ConfKey.PORT_NUMBER.ToString(), this.textBoxPort.Text);

            mythread = new Thread(new ThreadStart(MyThread));//クライアント待機スレッド
            mythread.Start();
        }

        // サーバに接続するまで受つスレッド
        private void MyThread()
        {
            try
            {
                int ip_port = int.Parse(this.textBoxPort.Text);
                String ip_adderess = this.textBoxIP.Text;
                this.tcpClient = new TcpClient(ip_adderess, ip_port); //サーバー用オブジェクト生成

                this.Invoke((MethodInvoker)delegate// スレッドからのGUI操作部
                {
                     this.lblMessage.Text = "サーバとの接続している状態です。";
                     this.btnConnect.Enabled = false;
                     this.formUmehoshiEdit.ToolStripMenuItemTcpConnecting.Visible = true;
                     this.Visible = false;
                 });

                UmeTcpClientForm.stream = tcpClient.GetStream();//送受信ストリーム

                this.myRecthread = new Thread(new ThreadStart(MyRecThread));//受信処理スレッド
                this.myRecthread.Start();
            }
            catch (Exception err)
            {
                try
                {
                    this.Invoke((MethodInvoker)delegate
                    {
                        this.lblMessage.Text = err.Message;
                        Debug.Print(err.ToString());
                    });
                }
                catch (Exception) { }
            }
        }

        // 受信待ち受けスレッド
        private void MyRecThread()
        {
            _isRecRunning = true;
            bool firstLineFlag = true; // 1行目の受信処理状態でtrue
            string firstCmd = "";
            char cmd; // コマンド文字
            StreamRW streamRW = null;

            while (_isRecRunning)
            {
                try {
                    if (firstLineFlag)// 先頭の1行を読み込む処理
                    {
                        firstCmd = StreamRW.FirstReadLine(stream, ref this._isRecRunning);
                        if (firstCmd.Length < 1) continue;
                        cmd = firstCmd[0];
                        firstCmd = firstCmd.Substring(1);
                        if (cmd == 'M')
                        {
                            this.formUmehoshiEdit.Invoke((MethodInvoker)delegate // GUIアクセス用
                            {
                                // 出力先タブを前面にする。
                                formUmehoshiEdit.tabControl_UnderTAB.SelectedTab = formUmehoshiEdit.tabControl_UnderTAB.TabPages[1]; //TagPageの切り替え
                                formUmehoshiEdit.tabControl_UnderTAB.TabPages[1].Select();
                                UmehoshiEditForm.GetCommunicationTextBox.AppendText(firstCmd + "\r\n");

                            });
                            Debug.Print("MyRecThread:" + firstCmd);
                        }
                        else if (cmd == 'F' || cmd == 'f')
                        {
                            string[] a = firstCmd.Split(new char[] { ' ' });
                            int size = int.Parse(a[1]);
                            streamRW = new StreamRW(a[0], size);
                            streamRW.actionFlag = cmd == 'f';
                            firstLineFlag = false;
                        }
                        else if (cmd == 'B')// サウンドなどのブロック情報(読み取り指定のみ)
                        {
                            string[] a = firstCmd.Split(new char[] { ' ' });
                            int size = int.Parse(a[1]);
                            streamRW = new StreamRW(a[0], size);
                            streamRW.actionFlag = cmd == 'f';
                            firstLineFlag = false;
                        }
                    }
                    else // 先頭を除いた処理の読み込み
                    {
                        bool ok = streamRW.ReadToBuffer(stream);//指定サイズ(streamRW.readBuffer.Length)を読み取る
                        if (ok)
                        {
                            StreamRW.requestFile = streamRW;// ファイル生成の要求をセット(使っていない)
                            firstLineFlag = true;
                        }

                    }
                }
                catch(Exception err)
                {
                    _isRecRunning = false;

                    Debug.Print(err.ToString());
                }
            }
            TcpClose();
            _isRecRunning = false;
            try
            {
                this.formUmehoshiEdit.Invoke((MethodInvoker)delegate // GUIアクセス用
                {
                    this.formUmehoshiEdit.ToolStripMenuItemTcpConnecting.Visible = false;
                    this.formUmehoshiEdit.formTcpClient = null;
                    this.Dispose();
                });
            }
            catch (Exception ) { }
        }

        private void UmeTcpClientForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true;//フォームを閉じずに見えなくする。
            this.Visible = false;
            //try
            //{
            //    this.TcpClose();
            //}
            //catch(Exception){ }
        }

        public void TcpClose()
        {
            _isRecRunning = false;// スレッド終了
            try
            {
                if (stream != null)
                {
                    stream.Dispose();
                    stream.Close();
                }
            }
            catch (Exception e) {
                Debug.Print(e.ToString());
            }
            try
            {
                if (this.tcpClient != null)
                {
                    this.tcpClient.Close();
                }
            }
            catch (Exception e)
            {
                Debug.Print(e.ToString());
            }
            stream = null;
            this.tcpClient = null;
        }
    }
}
