﻿using System;
using System.Collections;
using System.IO;
using System.Text.RegularExpressions;
using System.Diagnostics;

// a.lst.txt から .hexファイルを生成するメソッド「create_lst_to_hex」を提供するクラス

namespace umehoshiEdit
{
    public class UmeHex
    {
        // リトルエンディアンの並びで、引数を8桁の16進文字列を得る。
        static string getLittleEndianHexString(UInt32 u32)
        {
            string s = String.Format("{0,8:X8}", u32);//8文字分使い、X8で8に満たない箇所を0で埋める
                                                      // 例　0800019c　→　9c010008 と変換する。
            char[] a = s.ToCharArray();
            s = "" + a[6] + a[7] + a[4] + a[5] + a[2] + a[3] + a[0] + a[1];
            //Console.WriteLine(s);
            return s;
        }

        static void hexWrite(StreamWriter sw, ref UInt32 start_addr, UInt32[] datas, ref int count)
        {
            string sHex = "S";
            sHex += String.Format("{0,2:X2}", count * 4);//2文字分使い、X2で2に満たない箇所を0で埋める
            sHex += String.Format("{0,8:X8}", start_addr);//8文字分使い、X8で8に満たない箇所を0で埋める
            sHex += "00";//タイプ
            for (int n = 0; n < count; n++)
            {
                sHex += getLittleEndianHexString(datas[n]);
            }
            sHex += HexCom.checkSum(sHex);
            sw.WriteLine(sHex);
            start_addr = 0xffffffff;
            count = 0;
        }

        // lstPathのa.lst.txt から、hexPathのうめぼしhexファイルを生成する時に使う。
        public static void create_lst_to_hex(string lstPath, string hexPath)
        {
            //string s = "Disassembly of 		  section 1.S.scn1:";
            //string s = "a0000660:   24080080        li t0,128";
            Regex rgxData = new Regex(@"([0-9a-f]{8}):\s+([0-9a-f]{8})\s+(.+)");
            Regex rgxData2 = new Regex(@"([0-9a-f]{8}):\s+([0-9a-f]{8})\s+([0-9a-f]{8})\s+(.+)");
            Regex rgxData3 = new Regex(@"([0-9a-f]{8}):\s+([0-9a-f]{8})\s+([0-9a-f]{8})\s+([0-9a-f]{8})\s+(.+)");
            Regex rgxData4 = new Regex(@"([0-9a-f]{8}):\s+([0-9a-f]{8})\s+([0-9a-f]{8})\s+([0-9a-f]{8})\s+([0-9a-f]{8})\s+(.+)");
            Regex rgxSec = new Regex(@"(.+)\s+(.+)\s+section\s+(.+):");
            Regex rgxSep = new Regex(@"([0-9a-f]{8}) <(.+)>:");

            string now_section_name = "";// セクションスタート名

            UInt32 u_now_address = 0;// 現在の読み取り行のアドレス

            UInt32 start_addr = 0xffffffff; // 下記配列のデータが並ぶ先頭アドレス
            UInt32[] datas = new UInt32[256]; // hexデータ格納用
            int count = 0;//上記配列の格納数

            StreamReader sr = new StreamReader(lstPath);
            StreamWriter sw = new StreamWriter(hexPath);
            while (sr.Peek() != -1)
            {
                if (count >= 4)// 4count * 4 (32byte) で 16byteごとに
                {
                    hexWrite(sw, ref start_addr, datas, ref count);// datas配列のデータ群でhexファイルの1行を出力
                }
                string s = sr.ReadLine();
                Debug.Print(s);
                Match match;
                if ((match = rgxSec.Match(s)) != null && match.Success)// セクションの行か？
                {
                    if (count > 0)
                    {
                        hexWrite(sw, ref start_addr, datas, ref count);
                    }
                    Group g = match.Groups[3];
                    string secName = g.Value;//セクション名
                                             //if (secName == ".dinit") break;
                    now_section_name = secName;
                    //Console.WriteLine("Section name:" + now_section_name);
                    continue;
                }
                else if ((match = rgxSep.Match(s)) != null && match.Success)// 区切りの行？
                {
                    if (count > 0)
                    {
                        hexWrite(sw, ref start_addr, datas, ref count);
                    }
                    //Console.WriteLine("Separate name:" + match.Groups[2].Value);
                    continue;
                }
                else if ((match = rgxData.Match(s)) != null && match.Success)// データがある行か？
                {
                    Group g = match.Groups[1];//アドレス
                    UInt32 addr = Convert.ToUInt32(g.Value, 16);
                    Group gV = match.Groups[2];//値
                    if (start_addr == 0xffffffff)//各行のスタートが未設定？
                    {
                        if (addr < 0x80005000U) continue;
                        if (addr > 0x80005000U + 0x4fc0) continue;

                        start_addr = u_now_address = addr;
                        datas[count++] = Convert.ToUInt32(match.Groups[2].Value, 16);
                        if ((match = rgxData2.Match(s)) != null && match.Success)
                        {
                            datas[count++] = Convert.ToUInt32(match.Groups[3].Value, 16);
                            if ((match = rgxData3.Match(s)) != null && match.Success)
                            {
                                datas[count++] = Convert.ToUInt32(match.Groups[4].Value, 16);
                                if ((match = rgxData4.Match(s)) != null && match.Success)
                                {
                                    datas[count++] = Convert.ToUInt32(match.Groups[5].Value, 16);
                                }
                            }
                        }
                    }
                    else if (u_now_address + 8 == addr)
                    {
                        u_now_address += 4;
                        datas[count++] = Convert.ToUInt32(gV.Value, 16);
                    }
                    else if (u_now_address < addr)
                    {
                        while (u_now_address + 4 < addr)
                        {
                            u_now_address += 4;
                            datas[count++] = 0;// nop命令の追加
                        }
                        u_now_address = addr;
                        datas[count++] = Convert.ToUInt32(gV.Value, 16);
                        if (u_now_address != addr)
                        {
                            //Console.WriteLine("a.lst.txtのフォーマットの情報取得のエラー");
                            return;
                        }
                    }
                    //Console.WriteLine(u_now_address + "=" + addr + ": " + gV.Value);
                }
                else
                {
                }
            }
            if (count > 0)
            {
                hexWrite(sw, ref start_addr, datas, ref count);
            }
            sr.Close();
            sw.Close();
        }
    }
}