﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Text;
using System.Threading;
using System.Windows.Forms;

// USB CDC「Universal Serial Bus Communications Device Class」の通信関連の管理クラス
// CDCの初期化、接続管理、通信スレッドなど、
// HexComクラスのstaticメンバとして管理され、上記関連の動作する

namespace umehoshiEdit
{
    public class MySerialPort
    {

        System.IO.Ports.SerialPort myPort = null;//現在の通信対象Serialポート

        public string myPortName = "";// 上記のCOMポートのリスト名

        public static int com_rate = 0;// ボーレート（baudrate）別途で115200に設定

        private Thread receiveThread = null;// 受信スレッド

        //  '0xa' までの受信した時点で、実行するハンドラ
        public delegate void DataReceivedHandler(byte[] data);
        public event DataReceivedHandler DataReceived;//　これを介して利用側の処理を呼び出す。
        byte[] eventRecBuffer; //上記用伝達用バッファ


        ~MySerialPort()//デストラクタ
        {
            Stop();
        }

        // 使用可能なCOMポート名群の取得
        public static List<string> getComList()
        {
            List<string> list = new List<String>();
            Dictionary<string, string> dic = new Dictionary<string, string>();// 重複チェック用
            foreach (string portName in System.IO.Ports.SerialPort.GetPortNames())
            {
                if (dic.ContainsKey(portName))
                {
                    Debug.Print("GetPortNames() 重複ポートエラー　ポート名：" + portName);
                    continue;
                }
                list.Add(portName);
                dic.Add(portName, portName);
            }
            return list;
        }

        public bool isOpen()
        {
            if (myPort == null) return false;
            return myPort.IsOpen;
        }

        public void StartComPort(string comPort)// COMポートをオープンして、受信スレッドスタート
        {
            try {
                //PortName, BaudRate, Parity, DataBits, StopBitsの設定
                com_rate = int.Parse(HexCom.mainForm.toolStripComboBox_USB_Rate.Text);
                myPort = new System.IO.Ports.SerialPort(comPort, com_rate, System.IO.Ports.Parity.None, 8, System.IO.Ports.StopBits.One);
                //myPort = new System.IO.Ports.SerialPort(comPort, 921600, System.IO.Ports.Parity.None, 8, System.IO.Ports.StopBits.One);
                //myPort = new System.IO.Ports.SerialPort(comPort, 115200, System.IO.Ports.Parity.None, 8, System.IO.Ports.StopBits.One);
                //myPort = new System.IO.Ports.SerialPort(comPort, 9800, System.IO.Ports.Parity.None, 8, System.IO.Ports.StopBits.One);
                myPort.Open();
                this.myPortName = comPort;

                //受信スレッド開始
                receiveThread = new System.Threading.Thread(ReceiveData);// ReceiveDataメソッドをスレッドとして用意
                receiveThread.Start();
            }
            catch(Exception err)
            {
                myPort = null;// 次の通信開始時に、初期化を促すことになる。
                string msg = "【" + comPort + "】" + err.Message;
                throw new Exception(msg);
            }
        }

        public void Stop()
        {
            if (this.myPort != null)
            {
                try
                {
                    if (this.myPort.IsOpen)
                    {
                        this.myPort.Close();
                    }
                    else
                    {
                        Debug.Print("Stop時、Openしていない判定");
                    }
                }
                catch (Exception e)
                {
                    Debug.Print(e.Message + "myPortのClose() 実行エラー");
                }

                try
                {
                    this.myPort.Dispose();
                    Debug.Print("myPortの解放終了");
                }
                catch (Exception e)
                {
                    Debug.Print(e.Message + "MySerialPort.Stop() 実行エラー");
                }
                myPort = null;  // 次の通信開始時に、初期化を促すことになる。
                this.myPortName = "";
                Debug.Print("MySerialPort.Stop() 終了");
            }
        }

        // 受信のデリゲート処理用スレッド
        public void DataReceived_thread()
        {
            this.DataReceived(eventRecBuffer); //利用側定義のハンドラを呼び出す。
        }

        // 受信スレッド
        // 受信した「CR LF」までのbyte列を、bufferに設定して、利用側のハンドラ（DataReceived）を呼び出す。
        public void ReceiveData()
        {
            byte[] recBuffer = new byte[1024*4];//一回のbyte受信列が、このサイズに収まらなければならない。
            int idxRead = 0;
            bool recflag = false;// 1行分受信終了
            bool bufferOverFlag = false;
            int code = -1;

            while (receiveThread != null)
            {
                if (myPort == null || !myPort.IsOpen) break;
                try
                {
                    while (true)// テキストモードであれば1行を受信するまでの繰り返し！
                    {
                        code = myPort.ReadByte(); //byte受信（USBからの入力は、ここだけで行っている。）

                        if (code != -1 && UmePlotForm.adc_datas != null)// ADコンバータのデータ受信中か？
                        {
                            bool noEndFlag = UmePlotForm.setADC_data(code);// ADコンバータのデータ受信中
                            // 上記戻り値：UmePlotForm.adc_datas配列への読み取りが終わったら false
                            // (ここで、配列の読み取りが終わると、UmePlotForm.adc_datasは使われて、nullに設定される。)
                            //if (!noEndFlag)
                            //{
                            //    Debug.Print("UmePlotForm." + UmePlotForm.idx_set);
                            //    continue;
                            //}
                            if (noEndFlag && UmePlotForm.TextMode == false) continue;
                            // テキストモード時は、下へ進んでTextBoxへの表示も行う。
                        }

                        if (code == 0x0a || code == -1)//改行、またはストリーム終了判定
                        {
                            if (idxRead > 0 && recBuffer[idxRead - 1] == 0x0d) idxRead -= 1;//改行直前へ

                            if(UmePlotForm.adc_start_flag)// 前回の受信で、ADCの始まりと判定された？
                            {
                                UmePlotForm.adc_start_flag = false;
                                // ADCデータサイズ数の受信
                                string sv = "";
                                UmePlotForm.TextMode = recBuffer[0] == 'T';
                                for (int i = recBuffer[0]=='T'?1:0; i < idxRead; i++) sv += (char)recBuffer[i];
                                int size = Convert.ToInt32 (sv, 16);
                                UmePlotForm.adc_datas = new short[size];// 次よりADC受信開始（受信バッファサイズ確定）
                                Debug.Print("受信バッファ生成 size:" + size);
                            }
                            eventRecBuffer = new byte[idxRead];////改行直前までの情報格納用記憶域を生成
                            Array.Copy(recBuffer, eventRecBuffer, eventRecBuffer.Length);
                            recflag = true;// 1行分受信終了
                            break;
                        }
                        if(idxRead >= recBuffer.Length)// 1行の受信バッファフルの処理
                        {
                            eventRecBuffer = new byte[idxRead];////改行直前までの情報格納用記憶域を生成
                            Array.Copy(recBuffer, eventRecBuffer, eventRecBuffer.Length);
                            recflag = true;// 1行分受信していないが、バッファ一杯なので出力
                            HexCom.mainForm.Invoke((MethodInvoker)delegate
                            {
                                HexCom.mainForm.clearListUpCOM();
                                HexCom.mainForm.print_message("USB受信バッファが一杯なの強制出力！");
                                bufferOverFlag = true;
                            });
                            break;
                        }
                        recBuffer[idxRead++] = (byte)code;
                        //Console.WriteLine(idxRead + "byte目" + code.ToString("X") + ":" + (char)code);

                    }
                    if (recflag)// 1行分受信終了===========================================
                    {
                        recflag = false;

                        this.DataReceived(eventRecBuffer); //利用側定義のハンドラを呼び出す。
                        // 上記は、HexCom.dataReceived(byte[] data)を呼び出す。
                        // (そこで、表示用はキューを介して、表示される)
                        idxRead = 0;
                        if(bufferOverFlag) recBuffer[idxRead++] = (byte)code;

                    }
                    if (code == -1) throw new Exception(""); ;// ストリーム終端で終了
                }
                catch (Exception ex)// UMEHOSHI ITA リセット操作で、この例外がおきる。
                {
                    Debug.Print("ReceiveData関数の例外処理："+ex.ToString());
                    try
                    {
                        HexCom.mainForm.Invoke((MethodInvoker)delegate
                        {
                            HexCom.mainForm.clearListUpCOM();
                            HexCom.mainForm.print_message("受信スレッド内通信エラーでシリアルポートを初期化しました" );

                        });
                    }
                    catch (Exception err2) { Debug.Print(err2.ToString()); }
                    myPort = null;//現在の通信対象ポートで、次の通信開始時に、初期化を促すことになる。
                    myPortName = "";// 上記のCOMポートのリスト名

                    //ここでシリアル通信デバイスの初期
                    if (HexCom.mySerialPort != null)
                    {
                        Debug.Print(" 受信スレッドReceiveData()例外：" + ex);
                        HexCom.mySerialPort.Stop();
                        HexCom.mySerialPort = null;
                    }
                }
            }
            receiveThread = null;
        }

        public void SendDataCRLF(byte[] buffer) 
        {
            try
            {
                int len = buffer.Length;
                myPort.Write(buffer, 0, len);

                byte[] CR = { 0x0d, 0x0a };
                myPort.Write(CR, 0, 2);
                // Debug.Print(buffer.ToString());
            }
            catch (Exception ex){
                MessageBox.Show("USBを接続し直して、再接続すてください。USB送信エラー例外：" + ex.Message);
            }
        }

        public void SendDataCRLF2(byte[] buffer)
        {
            try
            {
                int len = buffer.Length;
                for(int offset = 0; offset < len; offset++)
                {
                    myPort.Write(buffer, offset, 1);
                    Thread.Sleep(10);
                }

                byte[] CR = { 0x0d, 0x0a };
                myPort.Write(CR, 0, 2);
                Debug.Print(buffer.ToString());
            }
            catch (Exception ex)
            {
                MessageBox.Show("USBを接続し直して、再接続すてください。USB送信エラー例外：" + ex.Message);
            }
        }
    }
}
