using System;
using System.Collections;
using System.IO;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using System.Diagnostics;

namespace umehoshiEdit
{
	/// <summary>
	/// BuildTool ̊Tv̐łB
	/// </summary>
	//rhNX

	//rh̎擾ASDK̏擾RXgN^ōsADo_build()\bhŖ|󂷂B
	//ʂ́ARXgN^Ŏw肷eLXg{bNX֏o

	public class BuildTool {
        private System.Windows.Forms.TextBox textBox_Message;//o͗p̃eLXg{bNX

        public string workingFullDirectory; // ob`\[Xt@C̈ʒu
        public string batchFullPath;       // ob`t@C

        private System.Diagnostics.Process m_MyProcess; //rhpvZX
		private System.Diagnostics.ProcessStartInfo m_MyProcessStartInfo;//N
		private System.Threading.ThreadStart m_RunReadStr;
		private System.Threading.ThreadStart m_RunReadErr;
		private	System.IO.StreamReader m_StreamReaderStr;
		private	System.IO.StreamReader m_StreamReaderErr;
		private bool buildErrFlag = false;
        public bool successFlag = true;

 		//RXgN^@|󌋉ʂ\textBoxɂALB
		// e평ݒARpC̈ʒuTĐݒȂ
		public BuildTool(System.Windows.Forms.TextBox textBox) {

			//RpCŎgXbh
			m_RunReadStr = new System.Threading.ThreadStart(this.run_read_str);
			m_RunReadErr = new System.Threading.ThreadStart(this.run_read_err);

			this.textBox_Message = textBox;
		}

        delegate void delegateSetText(string txt);
        void setText(string txt)
        {
            this.textBox_Message.SelectedText = txt + "\r\n";
        }

        private void run_read_str()
        {//Wo͂̓ǂݎ胁\bh
            string str;
            while ((str = this.m_StreamReaderStr.ReadLine()) != null)
            {
                if (str.StartsWith("OK"))
                {
                    successFlag = true;
                }
                this.textBox_Message.Invoke(new delegateSetText(setText), str);
            }
        }

        private void run_read_err()
        {//WG[o͂̓ǂݎ胁\bh
            string str;
            while ((str = this.m_StreamReaderErr.ReadLine()) != null)
            {
                this.textBox_Message.Invoke(new delegateSetText(setText), str);
            	buildErrFlag = true;
            }
        }

        // srcFullPath̃t@Crh邽߂́Aob`t@C𐶐BiJtH_̃pX sdkpathj
        // (ob`t@ĆAsrcFullPath + ".bat"̖OŁAsrcFullPathƓʒu)
        public void Create_batch_S(String srcFullPath, string sdkpath)
        {
            FileInfo fileInfo = new FileInfo(srcFullPath);
            DirectoryInfo di = fileInfo.Directory;  // srcPath̃pX̃fBNg擾
            FileInfo batFile = new FileInfo(srcFullPath + ".bat");
            this.workingFullDirectory = di.FullName;
            this.batchFullPath = batFile.FullName;

            using (StreamWriter sw = new StreamWriter(batchFullPath, false, System.Text.Encoding.GetEncoding(932)))
            {
                string newLine = "";
                sw.WriteLine(di.Root.ToString().Substring(0,2));// hCuṒu\v
                sw.WriteLine("cd " + workingFullDirectory);
                string s = @"set PATH=" + sdkpath + @"\bin;%PATH%" ;
                sw.WriteLine(s + newLine);
                sw.WriteLine("if exist a.s   del a.s" + newLine);
                sw.WriteLine("if exist a.lst del a.lst" + newLine);
                sw.WriteLine("if exist a.o   del a.o" + newLine);
                sw.WriteLine("if exist a.elf del a.elf" + newLine);
                sw.WriteLine("if exist a.lst.txt del a.lst.txt" + newLine);
                s = "xc32-gcc " + fileInfo.Name; // gq́Au.Sv̂͂I
                s += @" -S -mprocessor=32MX270F256B -I""./include"">a.s";
                sw.WriteLine(s + newLine);
                sw.WriteLine("if  %errorlevel% neq 0 goto L_END");
                s = @"xc32-as.exe -aml=""a.lst"" a.s -o a.o -I""./include""";
                sw.WriteLine(s + newLine);
                sw.WriteLine("if  %errorlevel% neq 0 goto L_END");
                s = "xc32-ld.exe a.o -V -o a.elf -mprocessor=32MX270F256B -L " + sdkpath + @"\pic32mx\lib\proc\32MX270F256B";
                sw.WriteLine(s + newLine);
                sw.WriteLine("if  %errorlevel% neq 0 goto L_END");
                s = @"xc32-objdump  -S a.elf>a.lst.txt";
                sw.WriteLine(s + newLine);
                sw.WriteLine("echo OK");
                sw.WriteLine(":L_END");
            }
            Debug.Print(workingFullDirectory);
        }       

        // srcFullPathC\[Xsdkpath̊Ŗ|󂷂邽߂̃ob`t@C𐶐B(.SĐiށj
        public void Create_batch_C(String srcFullPath, string sdkpath)
        {
            FileInfo fileInfo = new FileInfo(srcFullPath);
            string srcName = Path.GetFileNameWithoutExtension(srcFullPath);
            DirectoryInfo di = fileInfo.Directory;  // srcPath̃pX̃fBNg擾
            FileInfo batFile = new FileInfo(srcFullPath + ".bat");
            this.workingFullDirectory = di.FullName;//\[Xt@CtH_̐΃pX
            this.batchFullPath = batFile.FullName;
            FileInfo file_LD_info = new FileInfo(this.workingFullDirectory + "\\mylinkerscript.ld");
            
            using (StreamWriter sw = new StreamWriter(batchFullPath, false, System.Text.Encoding.GetEncoding(932)))
            {
                string newLine = "";
                sw.WriteLine(di.Root.ToString().Substring(0, 2));// hCuṒu\v
                sw.WriteLine("cd " + workingFullDirectory);
                string s = @"set PATH=" + sdkpath + @"\bin;%PATH%";
                sw.WriteLine(s + newLine);
                sw.WriteLine("if exist a.lst del a.lst" + newLine);
                sw.WriteLine("if exist a.o   del a.o" + newLine);
                sw.WriteLine("if exist a.elf del a.elf" + newLine);
                sw.WriteLine("if exist a.lst.txt del a.lst.txt" + newLine);
                s = @"xc32-gcc -G0 -g -mprocessor=32MX270F256B -O0 -falign-functions -mno-mips16 -falign-labels -S -I""./include"" ";
                s += fileInfo.Name;
                sw.WriteLine(s + newLine);// a.s̃t@CwóiCRpCj
                sw.WriteLine("if  %errorlevel% neq 0 goto L_END");

                s = @"xc32-as.exe -achmls=""a.lst"" -o a.o -I""./include"" " + srcName + ".s";
                sw.WriteLine(s + newLine);// a.õt@CwóiAZujXg̐w܂
                sw.WriteLine("if  %errorlevel% neq 0 goto L_END");

                s = "xc32-ld.exe a.o -V -o a.elf -mprocessor=32MX270F256B";
                s += " -L \"" + sdkpath + @"\pic32mx\lib\proc\32MX270F256B";
                s += "\" -L \"" + sdkpath + @"\lib\gcc\pic32mx\4.8.3";
                s += "\" -L \"" + sdkpath + @"\pic32mx\lib";//libgcc.a
                s += "\" -lc";//`_sprintf_cdnopuxX' ֐ȂǗp libc.a w 
                s += " -lm"; // `fpadd'`fptosi'֐ȂǗp libm.a w
                s += " -lpic32"; // memset֐ȂǗp libpic32.a w
                //s += " -ldebug";
                //s += " -ldsp";
                //s += " -ldspr2";
                //s += " -le";
                //s += " -llega-c";
                //s += " -lm-newlib";
                //s += " -lmfd";
                s += " -lgcc";//`write'`__udivdi3' `__umoddi3'֐ȂǗp libgcc.a w 
                s += " -Map a.map";

                if (file_LD_info.Exists)
                {
                    s += " --script ./mylinkerscript.ld";
                }
                sw.WriteLine(s + newLine); // a.elf̃t@CwóiNj
                sw.WriteLine("if  %errorlevel% neq 0 goto L_END");

                //s = @"xc32-objdump  -S a.elf>a.lst.txt";
                //s = @"xc32-objdump -h -t -S a.elf>a.lst.txt";
                s = @"xc32-objdump -D a.elf>a.lst.txt";
                sw.WriteLine(s + newLine);// a.lst.txt ̋tAZut@Cwo
                sw.WriteLine("echo OK");
                sw.WriteLine(":L_END");
            }
            Console.WriteLine(workingFullDirectory);
        }

        // srcFullPath̃t@Crh邽߂́Aob`t@C𐶐āArhBiJtH_̃pXsdkpathj
        public bool Do_build(String srcPath , string sdkpath)
        {
            // ob`t@C̍쐬
            successFlag = false;
            if (srcPath.EndsWith(".S")){
                Create_batch_S(srcPath, sdkpath);

            }
            else if (srcPath.EndsWith(".c") || srcPath.EndsWith(".cpp")) {
                Create_batch_C(srcPath, sdkpath);
                //Create_batch_C_Direct(srcPath, sdkpath);
            }
            else {
                return false;
            }


            this.textBox_Message.Text = ""; // bZ[WeLXg{bNXNA

            string strCompil_opt = "/c " + batchFullPath;//RpCIvViob`t@Cwj
            string strBuild;
            buildErrFlag = false;
            m_MyProcessStartInfo = new System.Diagnostics.ProcessStartInfo();
            m_MyProcessStartInfo.WorkingDirectory = this.workingFullDirectory;
            m_MyProcessStartInfo.FileName = "cmd.exe";
            m_MyProcessStartInfo.UseShellExecute = false;
            m_MyProcessStartInfo.CreateNoWindow = true;
            m_MyProcessStartInfo.RedirectStandardOutput = true;//_CNgw
            m_MyProcessStartInfo.RedirectStandardError = true;
            m_MyProcessStartInfo.Arguments = strCompil_opt;
            this.textBox_Message.Text = "";
            strBuild = workingFullDirectory + "" + batchFullPath + "̃t@Cs܂\r\n";
            this.textBox_Message.SelectedText = strBuild + "\r\n";

            m_MyProcess = new System.Diagnostics.Process();

            m_MyProcess.StartInfo = m_MyProcessStartInfo;
            try
            {
                m_MyProcess.Start();//rhs

                System.Threading.Thread threadReadStr = new System.Threading.Thread(this.m_RunReadStr);
                System.Threading.Thread threadReadErr = new System.Threading.Thread(this.m_RunReadErr);

                this.m_StreamReaderStr = m_MyProcess.StandardOutput;
                this.m_StreamReaderErr = m_MyProcess.StandardError;

                threadReadStr.Start();  //XbhJn
                threadReadErr.Start();

                while (m_MyProcess.HasExited == false)
                {
                    Application.DoEvents();
                    System.Threading.Thread.Sleep(10);
                }
                m_MyProcess.Close();
                while (threadReadStr.IsAlive || threadReadErr.IsAlive)
                {//XbhÎ҂B
                    Application.DoEvents();
                    System.Threading.Thread.Sleep(10);
                }
                if (buildErrFlag == false)
                {
                    String msg = this.textBox_Message.Text;
                    if (msg.IndexOf("error") == -1)
                    {
                        this.textBox_Message.SelectedText = "Build successful\r\n";
                    }
                }
                if (this.successFlag)
                {
                    string a_list_txt_path = Path.GetDirectoryName(srcPath);
                    a_list_txt_path += @"\a.lst.txt";

                    // a.lst.txt  .hext@C𐶐
                    UmeHex.create_lst_to_hex(a_list_txt_path, srcPath + ".hex");
                }
            }
            catch (Exception ex)
            {
                this.textBox_Message.SelectedText = ex.ToString();
                return false;
            }
            return true;
        }

        // this.textBox_Message̓eŁAu: vTāA
        // ΁A̍sIԂɂA̐̒lԂB
        // Ȃ΁@-1ԂB
        public int checkBuildError()
        {
            MatchCollection results
                = Regex.Matches(this.textBox_Message.Text, ":[0-9]+:");

            if(results.Count > 0)
            {
                var first = results[0];
                int firstIndex = first.Index;
                string firstString = first.Value;
                this.textBox_Message.SelectionStart = firstIndex;
                this.textBox_Message.SelectionLength = firstString.Length;
                Debug.Print("G[ӏ:" + firstString);
                string s = firstString.Substring(1, firstString.Length-2);
                int line = int.Parse(s);
                return line;
            }
            return -1;
        }
    }
}
