import sys         # btc.py 
import time
import threading

# https://pybluez.readthedocs.io/en/latest/install.html
import bluetooth

devices = bluetooth.discover_devices(lookup_names=True)
print("Found {} devices.".format(len(devices)))

n=0
for addr, name in devices: # ペアリングデバイスリストアップ
    print("No={}  {} - {}".format(n, addr, name))
    n+=1

no=input("Device No=>>")

addr, name = devices[int(no)] # 上記選択デバイスをメモ
sock = bluetooth.BluetoothSocket(bluetooth.RFCOMM) # ソケット生成
uuid = '00001101-0000-1000-8000-00805F9B34FB' # SPP (シリアルポートプロファイル) の UUID
service = []
retry = 1
while len(service) == 0: # 接続予定のデバイスのサービスが存在するか？のチェックで、見つかるまで繰り返す。
     print( "Looking for service on {0}, try {1}".format(addr, retry) )
     service = bluetooth.find_service(address=addr, uuid=uuid)
     retry = retry + 1
     time.sleep(1)

if len(service) != 1:
    print("not find service.")
    exit(1)

# print(service)
service = service[0]
for k in service: # 見つかったデバイス情報を表示
    print("\t", k, ":" , service[k])

print( "Service found. Name={0}".format(service["name"]) )
print( "Connecting to service." )
sock = bluetooth.BluetoothSocket(bluetooth.RFCOMM)
try:
   sock.connect((addr, service["port"])) # 接続！！
   print( "Connected to service on {0} on port {1}".format(addr, service["port"]) )
except bluetooth.btcommon.BluetoothError as e:
   print( "Connection failed: {0}".format(e) )
   exit(0)

loop_flag=True
def read_loop(): # 受信スレッド用の関数
    global loop_flag
    while loop_flag:
        try:
            b=sock.recv(1) # binaryで1byte入力
            #print(type(b), b)
            print( chr(b[0]), end="") # 文字に変換して表示
        except:
           print("End Thread") 
           loop_flag = False
           return

# スレッドに read_loop 関数を渡す
t_id = threading.Thread(target=read_loop)
t_id.start() # スレッドスタート

while True: # 送信用のループ
    s = input("input>") # 送信文字列のキー入力
    if s == "": break # Enterだけすると、終了
    s += "\r\n"
    sock.send(s.encode('ascii')) # byteに変換して送信

sock.close()
