#include <xc.h> // infrared.c
#include "common.h"

void init_timer4() //荞݂̏JX^}CY֐
{
	T4CON =0x00000000;//typeB,16bit, [1:1]vXP[
	TMR4=0x00000000; //16bit^C}̐ݒl(WX^JEgAbv)
	PR4=351; //	8.775e-06bԊů݁i1/38e3/3j
	IPC4bits.T4IP = 6; // Set priority level = 6(2Ԃɑ傫ȗDx)
	IPC4bits.T4IS = 0;// Set sub-priority level = 3(ől)
	IFS0bits.T4IF = 0;// Clear the timer interrupt status flag
	IEC0bits.T4IE = 1;// Timer4 Enablei݋j.
}

int frame_status = 0; 
  //0:start҂, 1:frameM(ends), 2: M,@3:M,@4:Error.
int FRAME_START_COUNT_VAL = 273;//start̔ɕKv1̊ԂɑJEgl .
int FRAME_END_COUNT_VAL = 14814;//end̔ɕKv0̊ԂɑJEgl i0.13b) .
int idx_rec=3;//M̃^C~OLʒuiŏ̃LA̋L^ʒuj.
int rb5_on = 0;	// LA1ALA0
int prev_rb5_on=0;// L̕ωAݎ̏ԂLiȌԁj.

int timing_counter= 0;

// _MEMO3 idxʒuցAdataϒTCYŋLA̋LpCfbNXԂ.
int store(int idx, int data)
{
	for(;;) {
		_MEMO3[idx++] = data;//JEgl̋L^.
		data >>= 7;
		if(data != 0) _MEMO3[idx-1] |= 0x80;//̋L?
		else return idx;
	}
}

// _MEMO3 idxʒuɂϒf[^*dataɋLA̋LpCfbNXԂ.
int restore(int idx, int *data)
{
	*data = 0;
	int shift7 = 0;
	for(;;){
		int temp = _MEMO3[idx++];

		*data += (temp & 0x7f) << shift7; 
		if( (temp & 0x080) == 0 ) return idx;
		shift7 += 7;
	}
}

void rec_infrared() // ԊOM@i_PTR_RAM_AREA3+3 ԒnA^C~OLj
{
	if( idx_rec >= 0x0F00) {// \zL𒴂ꍇ̃G[
		_debug_hex4(15,15,1);
		frame_status = 4;
		return;
	}
	prev_rb5_on = rb5_on;
    	rb5_on = (PORTB & 0x80) == 0; // LA 1L.
	if( frame_status == 0 ) { // start҂.
		if( rb5_on == 0) {
			timing_counter= 0;
			return;// t[Jn^C~OJE^NA.
		}
		timing_counter++;
            if( timing_counter >= FRAME_START_COUNT_VAL ){
			// t[JnƂԂLowH.
			frame_status = 1; // frameMn܂Ɣf.
			//_debug_hex4(1,1,1);
		}
	} else if( frame_status == 1 ){ // frame̎M end check.
		timing_counter++;
		if( prev_rb5_on == 0 && timing_counter >= FRAME_END_COUNT_VAL ){//t[Ĩ`FbN.
			idx_rec=store(idx_rec,timing_counter);//JEgl̋L^.
			store(0,idx_rec);//L^̐ݒ
			frame_status = 2; //M
			_RB15 = 1; // LED D1()ON:MIƂoIɒm点B.
			rb5_on = prev_rb5_on=0;
			//_debug_hex4(2,2,1);
		}
		if( rb5_on == 0 && prev_rb5_on != rb5_on ) {// ҂.
			idx_rec=store(idx_rec,timing_counter);//JEgl̋L^.
			timing_counter= 0;
			return;
		} else if( rb5_on == 1 && prev_rb5_on != rb5_on ) {// オ҂.
			idx_rec=store(idx_rec,timing_counter);//JEgl̋L^.
			timing_counter= 0;
			return;
		}
	}
}


int idx_snd=1;//M̃^C~OLʒu .
int infrared_flag = 0; // ԊOLED̃LAONԂ1.
int timing_counter_t=0; // ^C~OςڕW̃^C~O.

void snd_infrared() // ԊOM.
{
	static int count = 0;
	if( idx_snd >= idx_rec ){// MIH.
		frame_status = 2;
		return; 
	}

	if( timing_counter == 0 ){
		infrared_flag = ! infrared_flag;//LA].
		count = 0;
	}

	if( infrared_flag != 0 && count == 0 ){
		_RB5 = 1; // ԊOLED_.
		__asm__ ("NOP");
	} else {
		_RB5 = 0;
		__asm__ ("NOP");
	}
	if(++count == 3) count = 0;// LA@1/3 duty.

	if(++timing_counter >= timing_counter_t){
		timing_counter = 0;
		idx_snd = restore(idx_snd, & timing_counter_t);//̃^C~O擾.
		//_send_decimal(  timing_counter_t,8);
		//_send_decimal(  idx_snd,8);
		//_send_string("<--  timing_counter_t, idx_snd\r\n");
	}
}


void timer4() //荞݊֐.
{
	static int print_flag = 0;
	if( frame_status < 2){
		print_flag = 1; 
		rec_infrared();//M.
		return;
	} else if( frame_status == 3 ){
		print_flag = 1; 
		snd_infrared();//M.
		return;
	}

	//static int count=0;//fobNmFp
	//if(count++ % 100000 != 0) return;

	if( print_flag == 0) return;

	int size = _get_capacity();
	if( size  < 10) return; //c̏o̓obt@ubN10Ȃo͂ȂB .
	if( _request_acc_outbuff(_ID_ACCESS_T4_TASK) == 0 ) return; 

	_send_decimal(frame_status ,8);
	_send_string("<--frame_status \r\n");
	
	_send_decimal( idx_rec,8);
	_send_string("<-- idx_rec\r\n");

	int tc=0; 
	int idx= restore(3, & tc);
	_send_decimal( tc ,8);
	_send_string("<-- Leader\r\n");
	idx= restore(idx, & tc);
	_send_decimal( tc ,8);
	_send_string("<-- T0\r\n");
	idx= restore(idx, & tc);
	_send_decimal( tc ,8);
	_send_string("<-- T1\r\n");

	_release_acc_outbuff(_ID_ACCESS_T4_TASK);
	print_flag = 0;
}

__attribute__((address( 0x80005000 ))) void start (void);
void start()
{
	_send_string("START\r\n");

	if(frame_status == 2){// ɎMIĂH .
		frame_status = 3;// M 
		timing_counter= 0;
		infrared_flag = 0; // ̓LAitiming_counter==0ɔ]j.
		//ŏ̃LÃ^C~O擾 .
		idx_snd = restore(3, &timing_counter_t);
		_send_decimal(  timing_counter_t,8);
		_send_decimal(  idx_snd,8);
		_send_string("<--  timing_counter_t, idx_snd\r\n");
		return;
	}
	prev_rb5_on=0;//RB5̏ 
	_RB5 = 0; // ԊOLEDOFF 
	__asm__ ("NOP");
	_HANDLES[_IDX_INIT_TIMER_4_5] = init_timer4;// 荞ݏ֐̃ftHgύX .
	_HANDLES[_IDX_TIMER_4_FUNC] = timer4;// 荞݊֐̃ftHgύXo^ .
	init_timer4(); 
	T4CONbits.ON = 1;// Start timer4
	_RB15 = 0; // LED D1()OFF
}

