package sprite;
import java.awt.Dimension;//Image,Graphics2Dp
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;

import javax.swing.JComponent;//JComponentASwingUtilitiesp
import javax.swing.SwingUtilities;
// BufferedImageA ImageObserverp

//`Ώۂ̃plA`ƃANṼXbhNX
public class SpriteThread extends SpriteBasic implements Runnable
{
	public JComponent targetComponent;//`Ώ// 2016-7-4 public ǉ

	Thread thread;//`AANVpXbh

	private boolean loopFlag;//Xbh𐧌䂷tO
	private int animationInterval;//actionsԊui~bj

	//`TCYƁA`Ώۂw肷RXgN^
	public SpriteThread(int width, int height, JComponent component){
		super(width, height);
		targetComponent = component;
		targetComponent.setDoubleBuffered(true);//_uobt@Ogp
		targetComponent.setPreferredSize(new Dimension(width, height));
	}

	//`ƃANṼXbhX^[gA`ƃANV̎sԊu(ms)Ŏw
	public void start(int msec){
		this.animationInterval = msec;//~b
		this.loopFlag = true;
		this.thread = new Thread(this);
		this.thread.start();//XbgX^[g
	}

	public void stop()
	{//`ƃANṼXbh~
		this.loopFlag = false;
	}

	public void paintTo(Graphics g)	{//`Ώۂɕ`悷郁\bhipaintComponentŗp郁\bhj
		try	{
			Graphics2D g2 = (Graphics2D)g;
			Image img = this.getImage();//`悷ׂC[W擾
			g2.drawImage(img, 0, 0, targetComponent);//`
		}
		catch (Exception e){
			e.printStackTrace();
			System.exit(1);
		}
	}

	public void run(){//`ƃANṼXbh
		while(loopFlag){
			try{
				this.action();//ANV

				//`pXbh̎s
				SwingUtilities.invokeLater(new SpriteDrawThread(targetComponent));

				//wԊu܂ŃX[v
				long nextTimer = System.currentTimeMillis() + this.animationInterval;
				while (loopFlag && nextTimer > System.currentTimeMillis()){
					Thread.sleep(1);//0.001bԁÃXbhs
				}
			}
			catch(Exception e){
				e.printStackTrace();
				loopFlag = false;
			}
		}
	}
}

//Swingp̕`XbgNX (VOXbhȂ̂ŁAɑΉXbhp)
class SpriteDrawThread implements Runnable
{
	private JComponent target;// `Ώ

	SpriteDrawThread(JComponent target){//`ΏۂRXgN^Ŏw
		this.target = target;
	}

	public void run(){//`Xbh
		target.repaint();
	}
}
