package sprite;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;//Image,Graphics2Dp
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;//ImageObserverp
import java.awt.image.ImageObserver;
//Point2DAffineTransforp;

// {Sprite
public class SpriteBasic extends Sprite
{
	protected boolean clearImageFlag = false;// ǉ()

	public SpriteBasic(int width, int height){//TCYwRXgN^
		super(width,height);
	}

	public SpriteBasic(Image img){//C[WwRXgN^
		super(img);
	}

	//Spritẽ\bhFefނ̃ANVꂼs(ʂɎ̍ipɃI[o[ChB)
	@Override
	protected void action(){
		Sprite []a;
		synchronized (subSprite){//ׂĂ̕`ΏۂAzɐݒ肵ĂAŕ`悷
			a = subSprite.toArray(new Sprite[subSprite.size()]);
		}
		for (int i = 0; i < a.length; i++){
			a[i].action();//q̓s
		}
	}

	//Spritẽ\bhFC[W擾isubSpriteꍇ͍ċAIɍsj
	@Override
	public Image getImage() throws Exception{
		if (this.image instanceof BufferedImage == false){
			return this.image;//ҏWĂ͂ȂC[WȂA^[
		}
		Graphics2D g2 = (Graphics2D)this.image.getGraphics();


		if(clearImageFlag){//2016-7-24 ύX 
			g2.setBackground(new Color(0,0,0,0));
			int w = ((BufferedImage )this.image).getWidth();
			int h = ((BufferedImage )this.image).getHeight();
			g2.clearRect(0, 0, w, h);
		}


		Sprite []a;
		synchronized (subSprite){
			a = subSprite.toArray(new Sprite[subSprite.size()]);
		}
		for (int i = 0; i < a.length; i++){
			Sprite sprite = a[i];//efގ擾
			if (sprite.visibled == false) continue;
			Image img = sprite.getImage();
			AlphaComposite omposite = AlphaComposite.getInstance(AlphaComposite.SRC_OVER, sprite.alpha);
			g2.setComposite( omposite );//`̍w@ݒ

			sprite.setDrawParameter();// iʒuAXP[A]j̐ݒ

			g2.drawImage(img, sprite.trans, null);//ItXN[֕`悷B
		}
		return this.image;//`悵IItXN[iC[Wj߂
	}


	public Sprite [] search(int x, int y){//subSpriteA̍W(x,y)ɈʒuSpriteQԂB
		Point pt = new Point(x,y);
		SpriteFitInterface<Point> fitObj = new SpriteFitInterface <Point>() {
		    public boolean fitWith(Sprite obj, Point p){//C^[tFCX̎\bh

		            ImageObserver observer = null;
		            if(obj.parent instanceof SpriteThread){
		                observer = ((SpriteThread)obj.parent).targetComponent;
		            }
		            Dimension size = obj.getSize(observer);
		            Point pt = new Point((int)obj.x, (int)obj.y);
		            Rectangle rect = new Rectangle(pt, size);
		            return rect.contains(p);//W`GAȂtrue
		    }
		};//----SpriteFitInterfaceC^[tFCXpNX̒`͈
		return getFitSprites(fitObj, pt);// fitObjɓKsubSpriteIuWFNgԂ
	}
}
