package sprite;//pbP[W
import java.awt.Dimension;
import java.awt.Image;//Graphics2DȂǗp
import java.awt.geom.AffineTransform;//AffineTransform;
import java.awt.image.BufferedImage;//BufferedImage,ImageObserverȂǗp
import java.awt.image.ImageObserver;
import java.util.ArrayList;//ArrayListȂǗp
import java.util.Collections;
import java.util.List;
import java.util.Random;

// Aj[Vfނ̃C[WAɎgfނ𕡐Ǘ邽߂̒ۃNX
abstract public class Sprite
{
	public static Random rand = new  Random(123);//p

	protected Sprite parent;//eSprite

	public double x = 0;	//ʒu(W)
	public double y = 0;

	//`ŎgItXN[C[W(RXgN^Őݒ)
	public Image image;

	//drawp̍Wϊp^p
	public AffineTransform trans = AffineTransform.getTranslateInstance(0, 0);//protectedύX

	//̏LC[WɎgSpriteQ(XbhZ[tListCX^X)
	public List<Sprite> subSprite = Collections.synchronizedList(new ArrayList<Sprite>());

	public double scaleX = 1;//@gk
	public double scaleY = 1;//c@gk
	public double angle = 0;//px PʁFdegree
	public double cx = 0;	//px ̒SWX(gk̃LN^W)
	public double cy = 0;	//px ̒SWY
	public float alpha = 1.0F; //sx(01.0)
	public boolean visibled = true;	//

	public void setSize(int width, int height){//TCYύX
		this.image = new BufferedImage(width, height, BufferedImage.TYPE_4BYTE_ABGR);
	}

	//`ɂăTCY擾(͈ʂɕ`R|[lg)
	public Dimension getSize(ImageObserver observer){
		int width = this.image.getWidth(observer);
		int height = this.image.getHeight(observer);
		return new Dimension(width,height);
	}

	protected Sprite(int width, int height){//RXgN^
		setSize(width, height);
	}

	protected Sprite(Image img){//RXgN^
		this.image = img;
	}

	public void add(Sprite sprite){//`fނ̒ǉ
		synchronized (subSprite){
			subSprite.add(sprite);
			sprite.parent = this;//ew
		}
	}

	public void delete(Sprite sprite){//`fނ̍폜){
		synchronized (subSprite){
			subSprite.remove(sprite);
		}
	}

	//̕`fނ̃C[WԂ
	abstract public Image getImage() throws Exception;

	//o^̃ANVItrue
	abstract protected void action();

	//Aڕ`Ŏgep^iʒuAXP[A]jɕϊ
	public void setDrawParameter(){
		AffineTransform scale = AffineTransform.getScaleInstance(scaleX, scaleY);
		AffineTransform rotate = AffineTransform.getRotateInstance(Math.toRadians(angle), cx * 1, cy * 1);

		this.trans = AffineTransform.getTranslateInstance(this.x, this.y);//ړp^
		this.trans.concatenate(scale);// ړɉ]gݍ킹
		this.trans.concatenate(rotate);// ړɉ]gݍ킹
	}

	//subSpritẻϒz񂩂Aarg̕tobjƍvSpriteQԂB
	public <T> Sprite [] getFitSprites(SpriteFitInterface<T> obj, T arg){
	    ArrayList <Sprite> lst = new ArrayList <Sprite>();//KIuWFNgLp
	    for(int i = this.subSprite.size()-1; i >= 0; i--){//OւƒT
	        Sprite sprite = this.subSprite.get(i);
	        if( obj.fitWith( sprite , arg) ){//Kǉ
	            lst.add( sprite );
	        }
	    }
	    Sprite []t = new Sprite[0];
	    return lst.toArray(t);//zɂĕԂB
	}
}
