package test;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;

import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.Timer;

public class TestPanel2 extends JPanel implements ActionListener{
	JButton btnStop = new JButton("ストップ");
	javax.swing.Timer timer;
	double x=100,y=70;
	double r = 10;//描画する円の半径

	public TestPanel2()  {
		this.setPreferredSize(new Dimension( 400,300));//自身のサイズを指定
		this.add(btnStop);
		btnStop.addActionListener( new ActionListener(){//ボタン処理用の匿名クラスを生成

			@Override
			public void actionPerformed(ActionEvent e) {
				timer.stop();
			}

		});
		timer = new Timer(500 , this);// 0.5秒毎にactionPerformedを実行
		timer.start();//ここでタイマースタート
	}

	@Override
	public void paintComponent(Graphics g){//描画ルーチン
		super.paintComponent(g);
		Graphics2D g2 = (Graphics2D)g;
		draw( g2 );
	}

	public void draw(Graphics2D g2){
		g2.setBackground(new Color(240,240,240));//r,g,b の光の引数
		g2.clearRect(0, 0, this.getWidth(), this.getHeight());

		if(x == 100 && y == 70){//以前の座標から、次の座標へ移動する制御
			x = 300;
		} else if(x == 300 && y == 70){
			y = 270;
		} else if(x == 300 && y == 270){
			x = 100;
		} else if(x == 100 && y == 270){
			y = 70;
		}
		Shape shape = new Ellipse2D.Double(x-r, y-r, r*2, r*2);//楕円形状生成
		g2.setColor(Color.yellow);//色変更(塗りつぶし用)
		g2.fill(shape);//shape形状を塗りつぶし

		BasicStroke stroke = new BasicStroke(5.0f);
		g2.setStroke(stroke);
		g2.setColor(Color.blue);//色変更（輪郭の描画用）
		g2.draw(shape);//shape形状を描く
	}

	@Override	//タイマー用の処理
	public void actionPerformed(ActionEvent e) {
		System.out.println("actionPerformed");
		this.repaint();//この命令で再描画を指示している。
		//　これにより、paintComponentの描画ルーチンが呼ばれることになる。
	}

	public static void main(String[] args)  {
		new SpriteFrame(new TestPanel2());//前回作成したSpriteFrameを、このパネルを入れて生成
	}
}
