package test;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JPanel;

public class TestPanel1 extends JPanel implements ActionListener{
	JButton btnSquare = new JButton("四角");
	JButton btnCircle = new JButton("円");


	public TestPanel1()  {
		this.setPreferredSize(new Dimension( 400,300));//自身のサイズを指定
		this.add(btnSquare);
		this.add(btnCircle);
		btnSquare.addActionListener(this);//ボタンのクリック処理のインスタンスとしてthisを指定
		btnCircle.addActionListener(this);//ボタンのクリック処理のインスタンスとしてthisを指定
	}

	@Override
	public void paintComponent(Graphics g){
		super.paintComponent(g);
		Graphics2D g2 = (Graphics2D)g;
	}

	public static void main(String[] args)  {
		new SpriteFrame(new TestPanel1());//前回作成したSpriteFrameに、このパネルを入れて生成
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		System.out.println("actionPerformed");
		Graphics2D g2 = (Graphics2D)this.getGraphics();
		BasicStroke stroke = new BasicStroke(5.0f);
		g2.setStroke(stroke);
		g2.setColor(Color.blue);//色変更
		if(e.getSource()==this.btnSquare){
			g2.drawLine( 100, 70, 300,  70 );//線描画
			g2.drawLine( 300, 70, 300, 270 );//線描画
			g2.drawLine( 300,270, 100, 270 );//線描画
			g2.drawLine( 100,270, 100,  70 );//線描画
		} else if(e.getSource()==this.btnCircle){
			double r=200;//半径
			double q = 30;//デグリーの角度
			double x1,y1,x2,y2;
			x1 = 200; y1 = 0;
			x2 = Math.cos( Math.PI / 180  * q) * r;
			y2 = Math.sin( Math.PI / 180  * q) * r;
			g2.drawLine( (int)x1 ,(int)y1, (int)x2, (int)y2 );//線描画
		}
	}

}
