package fishgame;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;

import javax.imageio.ImageIO;
import javax.sound.sampled.Clip;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

import fishgame.Harpoon.State;
import sprite.SoundData;
import sprite.Sprite;
import sprite.SpriteBasic;//ライブラリ利用
import sprite.SpriteFrame;
import sprite.SpriteThread;

public class TestSplitePanel2 extends JPanel implements MouseListener,MouseMotionListener  {
	static SpriteFrame frame;

	MySpriteThread spriteThread;	// 描画、アニメーションスレッド
	static {
		URL url=TestSplitePanel2.class.getResource("EmptyDream.mid");
		SoundData midi = new SoundData(url);
		midi.clip.loop(Clip.LOOP_CONTINUOUSLY);
	}

	JLabel label = new JLabel("0秒で0匹捕まえました。");

	public TestSplitePanel2() throws Exception {
		int w = SpriteBackGround.img.getWidth(this);//背景画像サイズ取得
		int h = SpriteBackGround.img.getHeight(this);
		this.setPreferredSize(new Dimension(w,h));
		spriteThread = new MySpriteThread(w, h, this);

		this.add(label);//ラベル追加
		label.setFont(new Font("Serif", Font.BOLD, 20));
		label.setForeground(Color.white);
		this.setCursor(spriteThread.cursor[0]);//カーソル設定

		spriteThread.start(10);//0.01秒のアクションスレッド スタート
		this.addMouseListener(this);//イベント用インスタンス設定
		this.addMouseMotionListener(this);//イベント用インスタンス設定
	}

	public void paintComponent(Graphics g){//間隔（0.01秒）で呼び出される。
		super.paintComponent(g);
		if (spriteThread == null) return;
		spriteThread.paintTo(g);//描画処理
		if(label != null) {
			String s = spriteThread.getLabelText();
			label.setText(s);//状況の表示
		}
	}

	public static void main(String[] arg) throws Exception{
		frame = new SpriteFrame(new TestSplitePanel2());//フレーム作品実行
	}

	@Override
	public void mouseClicked(MouseEvent e) {	}

	@Override
	public void mousePressed(MouseEvent e) {
		if(spriteThread.endFlag) {
			if(this.spriteThread.count < 10){
				return;
			}
			frame.setVisible(false);
			try {
				new SpriteFrame(new TestSplitePanel1());//フレーム作品実行
			} catch (Exception e1) {
				e1.printStackTrace();
			}
			return;
		}
		Point pt = e.getPoint();//マウス位置取得
		this.setCursor(spriteThread.cursor[2]);
		Dimension dim = this.spriteThread.net.getSize(this);


		Sprite[] sprites = spriteThread.search(pt.x, pt.y);//この位置のSprite集合を得る
		boolean hit = false;
		for(Sprite s : sprites){
			if(s instanceof SpriteFishB) {//魚のSprite
				spriteThread.dragFish = (SpriteFishB)s;
				spriteThread.dragFish.setDrag(pt);
				spriteThread.dragFish.state = SpriteFishB.State.捕まる;
				//System.out.println(s);//デバック用表示
				hit = true;
				break;
			}
		}
		if(! hit){ //魚でクリックできなかった。
			for(Sprite s : this.spriteThread.subSprite){
				if(s instanceof SpriteFishB == false) continue;
				SpriteFishB f = (SpriteFishB)s;
				if(f.visibled == false){
					System.out.println("失敗："+s.visibled);
					f.visibled = true;
					break;
				}
			}
			spriteThread.appearFish();//魚を出現させる
		}
	}
	@Override
	public void mouseReleased(MouseEvent e) {
		if(spriteThread.endFlag) return;
		this.setCursor(spriteThread.cursor[0]);
		if(spriteThread.dragFish != null){
			spriteThread.dragFish.setDrag(null);
			spriteThread.dragFish = null;
		}
	}
	@Override
	public void mouseEntered(MouseEvent e) {	}
	@Override
	public void mouseExited(MouseEvent e) {	}
	@Override
	public void mouseDragged(MouseEvent e) {
		if(spriteThread.endFlag) return;
		if(spriteThread.dragFish != null){
			spriteThread.dragFish.setDrag( e.getPoint() );
		}
	}
	@Override
	public void mouseMoved(MouseEvent e) {
		//System.out.println(e.getPoint());
	}
}
