package fishgame;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.net.URL;
import java.util.Random;

import javax.imageio.ImageIO;
import javax.swing.JLabel;
import javax.swing.JPanel;

import fishgame.Harpoon.State;
import sprite.SoundData;
import sprite.Sprite;
import sprite.SpriteBasic;//ライブラリ利用
import sprite.SpriteFrame;
import sprite.SpriteThread;

class SpriteFishA extends SpriteBasic {//右から左に移動するクラス
	enum State { 通常, 削除へ};
	State state = State.通常;//状態
	double speed_x; // 移動速度（１回のactionで変更する横移動量）

	SpriteFishA(Image img,int px, int py, int speed){//コンストラクタ
		super(img);
		this.x = px;//初期位置
		this.y = py;
		this.speed_x = speed; //速度
	}
	@Override
	public void action(){//移動処理（SpriteThreadのanimationIntervalのミリ秒ごとに実行）
		super.action();//スーパクラス:SpriteBasicのactionを実行
		if(state == State.通常){
			this.x += this.speed_x;//移動
			if(this.x < -100) {//左に隠れたか？
				this.x = 680+rand.nextInt( 450 );	//右の見えない所に出現させる。
				this.y = rand.nextInt( 450 ) + 30;//出現させるY座標は乱数を使う
				this.speed_x = -( rand.nextInt(4)+4 );//速度も乱数
			}
		}else if(state == State.削除へ){
			if(this.visibled){
				this.y -= 1;//上に移動
				this.angle -= 1;//削除に至る時は、1度ずつの回転動作
				this.alpha *= 0.99F;//少しずつ透明に変化
				if(this.y < -10)this.visibled=false;//見えない位置へ移動した非表示へ
			} else {//非表示であれば？
				//親のSpriteのsubSprite(リスト)から自身を削除する
				this.parent.delete(this);
			}
		}
	}
}

public class TestSplitePanel1 extends JPanel implements MouseListener,MouseMotionListener  {
	Image bg = ImageIO.read(TestSplitePanel1.class.getResource("aqua00.jpg"));//背景素材イメージ
	Image ch = ImageIO.read(TestSplitePanel1.class.getResource("sanma00.gif"));//素材1イメージ

	SpriteThread spriteThread;	// 描画、アニメーションスレッド
	static Point mousePoint = new Point();//マウス位置
	Harpoon harpoon = new Harpoon(100,-30);//銛のインスタンス変数（座標指定）

	JLabel label = new JLabel("0秒で0匹捕まえました。");
	int sec=0;//経過時間
	int count=0;//捕らえた魚数
	boolean endFlag=false;

	public TestSplitePanel1() throws Exception {
		int w = bg.getWidth(this);//背景画像サイズ取得
		int h = bg.getHeight(this);
		this.setPreferredSize(new Dimension(w,h));
		spriteThread = new SpriteThread(w, h, this);

		spriteThread.add( new SpriteBasic(bg) );//背景を追加
		for(int n = 0; n < 20; n++){
			spriteThread.add( new SpriteFishA(ch,-100,300,-1));//魚追加
		}
		spriteThread.add( harpoon );//銛追加

		this.add(label);//ラベル追加
		label.setFont(new Font("Serif", Font.BOLD, 20));
		label.setForeground(Color.white);

		spriteThread.start(10);//0.01秒のアクションスレッド スタート
		this.addMouseListener(this);
		this.addMouseMotionListener(this);

	}

	public void paintComponent(Graphics g){//間隔（0.01秒）で呼び出される。
		super.paintComponent(g);
		//if (spriteThread != null) spriteThread.paintTo(g);
		//spriteThread.subSprite.get(0).x -= 1;//★★
		//spriteThread.subSprite.get(1).x += 1;//★★
		spriteThread.paintTo(g);//描画処理
		if(label != null && endFlag == false) {
			String s = String.format("%d秒で %d匹捕まえました。", sec++ /100, count);
			s += String.format("残り銛数：%d", MySpriteThread.count);
			label.setText(s);
		}
		if(label != null && endFlag) {
			String s = "<html><body style='color: red'>";
			s += String.format("%d秒で %d匹捕まえました。", sec /100, count);
			s += String.format("<br>ゲーム終了</body></html>");
			label.setText(s);
		}
		int nFish =0;
		for(Sprite s : this.spriteThread.subSprite){
			if(s instanceof Harpoon ){
				if( ((Harpoon)s).state != Harpoon.State.狙い )return;
			}
			if(s instanceof SpriteFishA ){
				nFish++;
			}
		}
		if(nFish == 0 || MySpriteThread.count==0)endFlag = true;
	}

	public static void main(String[] arg) throws Exception{
		new SpriteFrame(new TestSplitePanel1());//フレーム作品実行
	}
	@Override
	public void mouseClicked(MouseEvent e) {	}

	@Override
	public void mousePressed(MouseEvent e) {
		if(endFlag) return;
		Point pt = e.getPoint();//マウス位置取得
		if((e.getButton() == MouseEvent.BUTTON3) ){//マウス右ボタン
			if(MySpriteThread.count > 0 )harpoon.state = Harpoon.State.発射;
			return;
		}
		Sprite[] sprites = spriteThread.search(pt.x, pt.y);//この位置のSprite集合を得る
		boolean hit = false;
		for(Sprite s : sprites){
			if(s instanceof Harpoon) {//魚のSprite
				if(((Harpoon)s).state != Harpoon.State.射抜く) continue;
				((Harpoon)s).visibled=false;
				MySpriteThread.count++;
				this.count++;//数える。
				hit = true;
			}
		}
/*		if(! hit){ //魚でクリックできなかった。
			SpriteFishA fish = new SpriteFishA(ch,pt.x, pt.y,-Sprite.rand.nextInt(3)-1);//Spriteを生成
			spriteThread.add(fish);//さかなの追加
		}
*/
	}
	@Override
	public void mouseReleased(MouseEvent e) {	}
	@Override
	public void mouseEntered(MouseEvent e) {	}
	@Override
	public void mouseExited(MouseEvent e) {	}
	@Override
	public void mouseDragged(MouseEvent e) {	}
	@Override
	public void mouseMoved(MouseEvent e) {
		TestSplitePanel1.mousePoint = e.getPoint();
	}
}
