package fishgame;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.JComponent;

import sprite.Sprite;
import sprite.SpriteBasic;
import sprite.SpriteThread;

public class MySpriteThread extends SpriteThread{
	//static メンバ
	static Cursor []cursor = new Cursor[3];//マウスカーソル
	static {
		try {
			Image []hands = new Image[3];
			for(int i=0; i < hands.length; i++){
				hands[i]=ImageIO.read(MySpriteThread.class.getResource("hand"+(i + 1)+".png"));
				java.awt.Point pt = new java.awt.Point(10,10);//画像内のマウスポインタ位置
				cursor[i]=Toolkit.getDefaultToolkit().createCustomCursor(hands[i], pt, "");
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	//インスタンス メンバ
	SpriteFishB dragFish = null;
	SpriteBackGround back = new SpriteBackGround();//背景生成
	SpriteBackGround back2 = new SpriteBackGround();//背景生成
	SpriteNet net = new SpriteNet();
	int sec=10000;//制限時間　10ミリ秒
	static int count=0;//捕らえた魚数
	boolean endFlag = false;

	//コンストラクタ
	public MySpriteThread(int width, int height, JComponent component) {
		super(width, height, component);

		this.add( back );//背景を追加
		this.add( back2 );//背景を追加
		back2.x = - 640;

		for(int i=0; i < 20; i++){
			SpriteFishB fish = new SpriteFishB();
			this.add( fish );//魚追加
			fish.visibled = this.rand.nextBoolean();//乱数で見えるかどうかを指定
		}
		this.add( net );//背景を追加
	}

	//状況表示用文字列取得
	String getLabelText(){
		if(count >= 20){
			endFlag = true;
			return String.format(
			"<html><body>%d 匹捕まえて、クリヤしました。<br>クリックで次のゲームへ進めます。</body><html>",  count);
		}
		if(sec /100 <= 0){
			if(count >= 10){
				endFlag = true;
				return String.format(
				"<html><body>%d 匹捕まえて、クリヤしました。<br>クリックで次のゲームへ進めます。</body><html>",  count);
			} else {
				endFlag = true;
				return String.format("%d 匹しか捕らえられません。クリアできませんでした。",  count);
			}
		} else {
			return String.format("あと%d秒です。 %d匹捕まえました。", sec-- /100, count);
		}
	}

	SpriteFishB appearFish(){
		for(Sprite s : this.subSprite){
			if(s.visibled == true) continue;
			if(s instanceof SpriteFishB){
				s.visibled = true;
				s.x = -200;
				return (SpriteFishB) s;
			}
		}
		return null;
	}
}

class SpriteBackGround extends SpriteBasic{
	static Image img;//素材イメージ
	static {
		try {
			img = ImageIO.read(SpriteBackGround.class.getResource("aqua00.jpg"));
		} catch (IOException e) {e.printStackTrace();}
	}
	SpriteBackGround(){
		super(img);
	}
	protected void action() {
		super.action();
		this.x += 3;
		if(this.x > 640) {
			this.x = - 640;
		}
	}
}

class SpriteNet extends SpriteBasic{
	static Image []img = new Image[5];//素材イメージ
	static {
		try {
			for(int n = 0; n < img.length; n++ ){
				img[n] = ImageIO.read(SpriteBackGround.class.getResource(
						"net"+(n+1)+".png"));
			}
		} catch (IOException e) {e.printStackTrace();}
	}
	int idx=0;//画像添え字
	int idxUp = 1;
	int count=0;
	SpriteNet(){
		super(img[0]);
		this.scaleX=0.6;
		this.scaleY=0.6;
	}
	protected void action() {
		super.action();
		if(++count == 5){
			count = 0;
			idx += idxUp;
			if(idx >= img.length){
				idxUp = -1;
				idx=img.length-1;
			} else if(idx < 0){
				idxUp = 1;
				idx=0;
			}
			this.image=img[idx];
		}
	}
}
class SpriteFishB  extends SpriteBasic{
	static Image img;//素材イメージ
	static {
		try {
			img = ImageIO.read(SpriteFishB.class.getResource("sanma00.gif"));
		} catch (IOException e) {e.printStackTrace();}
	}

	enum State {通常,捕まる,網中};
	State state = State.通常;
	double speedX = this.rand.nextDouble() * 3 + 1;//速度
	double speedAngle = 5;//回転速度

	Point prevPt = null;//ドラック中は以前のマウス位置

	SpriteFishB(){
		super(img);
		this.x = this.rand.nextInt(640);
		this.y = this.rand.nextInt(480)+20;
	}

	protected void action() {
		super.action();
		if(this.state == State.通常){
			this.x -= this.speedX;
			if(this.x < -100) {
				this.x = 640;
			}
		} else if(this.state == State.捕まる || this.state == State.網中){
			if(this.angle > 30 || this.angle < -30){
				this.speedAngle = - this.speedAngle;
			}
			this.angle += this.speedAngle;
		}
	}

	void setDrag(Point pt){
		if(this.prevPt == null && pt != null){//ドラック開始
			this.cx = pt.x-this.x;
			this.cy = pt.y-this.y;
		} else 	if(pt != null && this.prevPt != null){//ドラックによる移動
			this.x += pt.x - this.prevPt.x;
			this.y += pt.y - this.prevPt.y;
			double diff = this.cx - 40;
			diff = Math.sqrt(diff * diff);
			if(this.rand.nextDouble() * diff > 15 ){//取りこぼし
				this.state = SpriteFishB.State.通常;
				this.angle = 0;
				this.speedX = 5 + rand.nextInt(10);
			}
		} else 	if(pt == null && this.prevPt != null){//ドラック終了
			MySpriteThread myThrtead = (MySpriteThread)this.parent;
			Dimension dim = myThrtead.net.getSize(myThrtead.targetComponent);
			dim.height *= myThrtead.net.scaleY * 0.7;
			dim.width *= myThrtead.net.scaleX * 0.7;
			System.out.println(dim);
			if(this.x > 0 && this.x < dim.width && this.y > 0 && this.y < dim.height){
				this.state = SpriteFishB.State.網中;
				myThrtead.count++;
				myThrtead.net.scaleX *= 1.1;
				myThrtead.net.scaleY *= 1.1;
			} else {
				this.state = SpriteFishB.State.通常;
				this.angle = 0;
				this.speedX = 5 + rand.nextInt(10);
			}
		}
		this.prevPt = pt;
	}
}
