package fishgame;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.URL;

import javax.imageio.ImageIO;

import sprite.SoundData;
import sprite.Sprite;
import sprite.SpriteBasic;
import sprite.SpriteThread;

public class Harpoon extends SpriteBasic{
	static Image ch ,ch2;//素材イメージ(狙い発射進行と、射抜く)
	static SoundData wav;

	static {
		try {
			ch = ImageIO.read(Harpoon.class.getResource("harpoon.png")); //通常の銛イメージ
			ch2 = ImageIO.read(Harpoon.class.getResource("sanma01.png")); //射抜いたイメージ
			URL url = Harpoon.class.getResource("water-drop1.wav");
			wav = new SoundData(url);
		} catch (IOException e) {e.printStackTrace();}
	}
	public enum State { 狙い, 発射, 進行, 射抜く};
	State state = State.狙い;//状態
	double speedY = 10;

	Harpoon(double px, double py){//コンストラクタ
		super(ch);
		this.x = px;//初期位置
		this.y = py;
	}
	@Override
	public void action(){//スレッドで繰り返される
		super.action();//スーパクラス:SpriteBasicのactionを実行

		if(this.state == State.狙い){
			this.x = TestSplitePanel1.mousePoint.getX();
		}
		else if(this.state == State.発射){
			this.state = State.狙い;
			Harpoon h = new Harpoon( this.x, this.y);
			MySpriteThread.count--;//銛カウント
			h.state = State.進行;
			this.parent.add(h); //親のspriteThreadに追加
			wav.replay();
		}
		else if(this.state == State.進行){
			this.y += this.speedY;
			SpriteThread parent = (SpriteThread)this.parent;
			Sprite[] sprites = parent.search((int)this.x, (int)this.y);//探す
			for(Sprite s : sprites){
				if(s instanceof SpriteFishA ){
					SpriteFishA sA = (SpriteFishA)s;
					if(sA.state == SpriteFishA.State.通常){
						this.parent.delete(sA);//魚は破棄
						this.state = State.射抜く;
						this.image = ch2; //射抜いたイメージへ変更
						return;
					}
				}
			}
			if(this.y > 800)this.parent.delete(this);//見えなくなった銛は破棄
		}
		else if(this.state == State.射抜く){
			this.y -= 1;//上に移動
			this.angle -= 1;//削除に至る時は、1度ずつの回転動作
			this.alpha *= 0.99F;//少しずつ透明に変化
			this.cx = 40;//回転の基準点を中央へ
			this.cy = 25;
			if(this.y < -10)this.parent.delete(this);//見えなくなった銛は破棄
		}
	}
}
