/*
 * Decompiled with CFR 0.152.
 */
package sprite;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import sprite.SpriteBasic;
import sprite.SpriteDrawThread;

public class SpriteThread
extends SpriteBasic
implements Runnable {
    public JComponent targetComponent;
    Thread thread;
    private boolean loopFlag;
    private int animationInterval;

    public SpriteThread(int n, int n2, JComponent jComponent) {
        super(n, n2);
        this.targetComponent = jComponent;
        this.targetComponent.setDoubleBuffered(true);
        this.targetComponent.setPreferredSize(new Dimension(n, n2));
    }

    public void start(int n) {
        this.animationInterval = n;
        this.loopFlag = true;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() {
        this.loopFlag = false;
    }

    public void paintTo(Graphics graphics) {
        try {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Image image = this.getImage();
            graphics2D.drawImage(image, 0, 0, this.targetComponent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    @Override
    public void run() {
        while (this.loopFlag) {
            try {
                this.action();
                SwingUtilities.invokeLater(new SpriteDrawThread(this.targetComponent));
                long l = System.currentTimeMillis() + (long)this.animationInterval;
                while (this.loopFlag && l > System.currentTimeMillis()) {
                    Thread.sleep(1L);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.loopFlag = false;
            }
        }
    }
}

