/*
 * Decompiled with CFR 0.152.
 */
package sprite;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JComponent;
import sprite.Sprite;
import sprite.SpriteFitInterface;
import sprite.SpriteThread;

public class SpriteBasic
extends Sprite {
    protected boolean clearImageFlag = false;

    public SpriteBasic(int n, int n2) {
        super(n, n2);
    }

    public SpriteBasic(Image image) {
        super(image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void action() {
        Sprite[] spriteArray;
        List list = this.subSprite;
        synchronized (list) {
            spriteArray = this.subSprite.toArray(new Sprite[this.subSprite.size()]);
        }
        for (int i = 0; i < spriteArray.length; ++i) {
            spriteArray[i].action();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Image getImage() throws Exception {
        Sprite[] spriteArray;
        if (!(this.image instanceof BufferedImage)) {
            return this.image;
        }
        Graphics2D graphics2D = (Graphics2D)this.image.getGraphics();
        if (this.clearImageFlag) {
            graphics2D.setBackground(new Color(0, 0, 0, 0));
            int n = ((BufferedImage)this.image).getWidth();
            int n2 = ((BufferedImage)this.image).getHeight();
            graphics2D.clearRect(0, 0, n, n2);
        }
        List list = this.subSprite;
        synchronized (list) {
            spriteArray = this.subSprite.toArray(new Sprite[this.subSprite.size()]);
        }
        for (int i = 0; i < spriteArray.length; ++i) {
            Sprite sprite = spriteArray[i];
            if (!sprite.visibled) continue;
            Image image = sprite.getImage();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, sprite.alpha);
            graphics2D.setComposite(alphaComposite);
            sprite.setDrawParameter();
            graphics2D.drawImage(image, sprite.trans, null);
        }
        return this.image;
    }

    public Sprite[] search(int n, int n2) {
        Point point = new Point(n, n2);
        SpriteFitInterface<Point> spriteFitInterface = new SpriteFitInterface<Point>(){

            @Override
            public boolean fitWith(Sprite sprite, Point point) {
                JComponent jComponent = null;
                if (sprite.parent instanceof SpriteThread) {
                    jComponent = ((SpriteThread)sprite.parent).targetComponent;
                }
                Dimension dimension = sprite.getSize(jComponent);
                Point point2 = new Point((int)sprite.x, (int)sprite.y);
                Rectangle rectangle = new Rectangle(point2, dimension);
                return rectangle.contains(point);
            }
        };
        return this.getFitSprites(spriteFitInterface, point);
    }
}

