/*
 * Decompiled with CFR 0.152.
 */
package sprite;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import sprite.SpriteFitInterface;

public abstract class Sprite {
    public static Random rand = new Random(123L);
    protected Sprite parent;
    public double x = 0.0;
    public double y = 0.0;
    public Image image;
    public AffineTransform trans = AffineTransform.getTranslateInstance(0.0, 0.0);
    public List<Sprite> subSprite = Collections.synchronizedList(new ArrayList());
    public double scaleX = 1.0;
    public double scaleY = 1.0;
    public double angle = 0.0;
    public double cx = 0.0;
    public double cy = 0.0;
    public float alpha = 1.0f;
    public boolean visibled = true;

    public void setSize(int n, int n2) {
        this.image = new BufferedImage(n, n2, 6);
    }

    public Dimension getSize(ImageObserver imageObserver) {
        int n = this.image.getWidth(imageObserver);
        int n2 = this.image.getHeight(imageObserver);
        return new Dimension(n, n2);
    }

    protected Sprite(int n, int n2) {
        this.setSize(n, n2);
    }

    protected Sprite(Image image) {
        this.image = image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Sprite sprite) {
        List<Sprite> list = this.subSprite;
        synchronized (list) {
            this.subSprite.add(sprite);
            sprite.parent = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Sprite sprite) {
        List<Sprite> list = this.subSprite;
        synchronized (list) {
            this.subSprite.remove(sprite);
        }
    }

    public abstract Image getImage() throws Exception;

    protected abstract void action();

    public void setDrawParameter() {
        AffineTransform affineTransform = AffineTransform.getScaleInstance(this.scaleX, this.scaleY);
        AffineTransform affineTransform2 = AffineTransform.getRotateInstance(Math.toRadians(this.angle), this.cx * 1.0, this.cy * 1.0);
        this.trans = AffineTransform.getTranslateInstance(this.x, this.y);
        this.trans.concatenate(affineTransform);
        this.trans.concatenate(affineTransform2);
    }

    public <T> Sprite[] getFitSprites(SpriteFitInterface<T> spriteFitInterface, T t) {
        ArrayList<Sprite> arrayList = new ArrayList<Sprite>();
        for (int i = this.subSprite.size() - 1; i >= 0; --i) {
            Sprite sprite = this.subSprite.get(i);
            if (!spriteFitInterface.fitWith(sprite, t)) continue;
            arrayList.add(sprite);
        }
        Sprite[] spriteArray = new Sprite[]{};
        return arrayList.toArray(spriteArray);
    }
}

