/*
 * Decompiled with CFR 0.152.
 */
package sprite;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundData {
    public Clip clip;

    public void setURL(URL uRL) {
        try {
            AudioFormat audioFormat = AudioSystem.getAudioFileFormat(uRL).getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, audioFormat);
            this.clip = (Clip)AudioSystem.getLine(info);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(bufferedInputStream);
            this.clip.open(audioInputStream);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            unsupportedAudioFileException.printStackTrace();
        }
        catch (LineUnavailableException lineUnavailableException) {
            lineUnavailableException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public SoundData(URL uRL) {
        this.setURL(uRL);
    }

    public SoundData(String string) {
        File file = new File(string);
        try {
            this.setURL(file.toURI().toURL());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void play() {
        this.clip.start();
    }

    public void replay() {
        this.clip.setMicrosecondPosition(0L);
        this.clip.start();
    }

    public void stop() {
        this.clip.stop();
    }

    public static void main(String[] stringArray) throws Exception {
        File file = new File("water-drop1.wav");
        URL uRL = file.toURI().toURL();
        SoundData soundData = new SoundData(uRL);
        File file2 = new File("EmptyDream.mid");
        URL uRL2 = file2.toURI().toURL();
        SoundData soundData2 = new SoundData(uRL2);
        soundData2.clip.loop(-1);
        soundData2.replay();
        soundData.replay();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        for (int i = 0; i < 5; ++i) {
            System.out.print("Enter \u3067\u518d\u751f");
            bufferedReader.readLine();
            soundData.replay();
        }
        soundData2.replay();
        System.out.print("Enter \u3067\u30d7\u30ed\u30b0\u30e9\u30e0\u7d42\u4e86 ");
        bufferedReader.readLine();
    }
}

